/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.requests.params;

import android.content.Context;
import com.inlocomedia.android.core.communication.util.CacheConfig;
import com.inlocomedia.android.core.communication.util.RestfulMethod;
import com.inlocomedia.android.core.communication.util.URIBuilder;
import com.inlocomedia.android.core.util.Validator;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpRequestParams {
    private String a;
    private String b;
    private byte[] c;
    private HashMap<String, Object> d;
    private HashMap<String, String> e;
    private Context f;
    private CacheConfig g;
    private boolean h;
    private String i;
    private boolean j;

    public HttpRequestParams(Context context, RestfulMethod restfulMethod) {
        Validator.notNull(context, "Context");
        this.f = context;
        this.e = new HashMap();
        this.g = CacheConfig.getDisabledConfig();
        this.setUrl(restfulMethod.getUrl());
        this.b = restfulMethod.getMethod();
    }

    public HttpRequestParams(Context context, String url) {
        this(context, new RestfulMethod(0, url));
    }

    public byte[] getBody() {
        return this.c;
    }

    public HttpRequestParams setBody(JSONObject body) throws UnsupportedEncodingException {
        this.c = body != null ? body.toString().getBytes("UTF-8") : null;
        this.h = true;
        return this;
    }

    public HttpRequestParams setBody(String body) throws UnsupportedEncodingException {
        this.c = body != null ? body.getBytes("UTF-8") : null;
        this.h = true;
        return this;
    }

    public HttpRequestParams setBody(byte[] body) {
        this.c = body;
        this.h = false;
        return this;
    }

    public String getUrl() {
        return this.i != null ? this.i : this.a;
    }

    public String getMethod() {
        return this.b;
    }

    public void buildUrl() throws UnsupportedEncodingException, JSONException {
        if (this.d != null) {
            this.i = URIBuilder.appendQueryToUrl(this.a, this.d);
        }
    }

    public HashMap<String, String> getHeaders() {
        return this.e;
    }

    public HttpRequestParams setHeaders(HashMap<String, String> headers) {
        this.e = headers;
        return this;
    }

    public Context getContext() {
        return this.f;
    }

    public HttpRequestParams setContext(Context context) {
        this.f = context;
        return this;
    }

    public HttpRequestParams addUrlParam(String key, String value) {
        if (this.d == null) {
            this.d = new HashMap();
        }
        this.d.put(key, value);
        return this;
    }

    public CacheConfig getCacheConfig() {
        return this.g;
    }

    public boolean isCacheEnabled() {
        return this.g != null && this.g.getType() == CacheConfig.Type.DEFAULT && this.g.getCacheManager() != null;
    }

    public boolean isResponseCacheable() {
        return this.g != null && this.g.getType() != CacheConfig.Type.DISABLED;
    }

    public void setCacheConfig(CacheConfig config) {
        this.g = config;
    }

    public boolean isBodyReadable() {
        return this.h;
    }

    public String getBodyAsString() throws UnsupportedEncodingException {
        return new String(this.c, "UTF-8");
    }

    public void setUrl(String url) {
        this.a = url;
    }

    public void setStoreData(boolean shouldStore) {
        this.j = shouldStore;
    }

    public boolean shouldStoreData() {
        return this.j;
    }

    public void addHeader(String key, String header) {
        if (this.e == null) {
            this.e = new HashMap();
        }
        this.e.put(key, header);
    }
}

