/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication;

import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.inlocomedia.android.core.communication.requests.params.HttpRequestParams;
import com.inlocomedia.android.core.communication.responses.UrlResponse;

public class RequestOverview {
    private HttpRequestParams a;
    private UrlResponse b;
    private long c;
    private Long d;
    private String e;
    private String f;

    public RequestOverview(Builder builder) {
        this.c = builder.e;
        this.a = builder.c;
        this.b = builder.d;
        this.d = builder.f;
        this.e = builder.a;
        this.f = builder.b;
    }

    public void setDuration(long duration) {
        this.d = duration;
    }

    public long getTimestamp() {
        return this.c;
    }

    @Nullable
    public Long getDuration() {
        return this.d;
    }

    @Nullable
    public Integer getRequestBodySize() {
        return this.a != null && this.a.getBody() != null ? Integer.valueOf(this.a.getBody().length) : null;
    }

    @Nullable
    public String getRequestUrl() {
        return this.a != null ? this.a.getUrl().replace("\\?.*$", "") : null;
    }

    @Nullable
    public Integer getResponseBodySize() {
        return this.b != null && this.b.getData() != null ? Integer.valueOf(this.b.getData().length) : null;
    }

    @Nullable
    public Boolean hasRequestError() {
        return this.b != null ? Boolean.valueOf(this.b.getErrorReceived() != null) : null;
    }

    @Nullable
    public String requestErrorMessage() {
        return this.b != null && this.b.getErrorReceived() != null ? this.b.getErrorReceived().getFormattedMessage() : null;
    }

    public String getConnectionType() {
        return this.e;
    }

    public String getConnectionSubtype() {
        return this.f;
    }

    public static class Builder {
        private String a;
        private String b;
        private HttpRequestParams c;
        private UrlResponse d;
        private long e;
        private Long f;

        public Builder request(@NonNull HttpRequestParams request) {
            this.c = request;
            return this;
        }

        public Builder response(@NonNull UrlResponse response) {
            this.d = response;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.e = timestamp;
            return this;
        }

        public Builder duration(Long duration) {
            this.f = duration;
            return this;
        }

        public Builder networkInfo(NetworkInfo networkInfo) {
            if (networkInfo != null && networkInfo.isConnectedOrConnecting()) {
                this.a = String.valueOf(networkInfo.getType());
                if (networkInfo.getType() == 0) {
                    this.b = String.valueOf(networkInfo.getSubtype());
                }
            }
            return this;
        }

        public RequestOverview build() {
            return new RequestOverview(this);
        }
    }
}

