/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import android.support.annotation.VisibleForTesting;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.models.Size;
import java.lang.reflect.Method;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;

public class ScreenHelper {
    private static final String d = Logger.makeTag(ScreenHelper.class);
    private static ScreenHelper e;
    private Float f;
    private Context g;
    @VisibleForTesting
    Boolean a;
    @VisibleForTesting
    BroadcastReceiver b;
    @VisibleForTesting
    protected CopyOnWriteArraySet<ScreenStateListener> mListeners;
    @VisibleForTesting
    AtomicBoolean c;

    public static synchronized ScreenHelper getInstance(Context context) {
        if (e == null) {
            e = new ScreenHelper(context);
        }
        return e;
    }

    @VisibleForTesting
    protected ScreenHelper(Context context) {
        this.g = context.getApplicationContext();
        this.a = null;
        this.f = null;
        this.c = new AtomicBoolean(false);
    }

    public static Size getScreenSizeInDp(Context context) {
        DisplayMetrics displayMetrics = ScreenHelper.a(context);
        Size size = ScreenHelper.getScreenSizeInPx(context);
        return new Size(Math.round(size.width / displayMetrics.density), Math.round(size.height / displayMetrics.density));
    }

    @SuppressLint(value={"NewApi"})
    public static Size getScreenSizeInPx(Context context) {
        int n = 0;
        int n2 = 0;
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics displayMetrics = ScreenHelper.a(context);
            n = displayMetrics.widthPixels;
            n2 = displayMetrics.heightPixels;
        } else {
            try {
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                Display display = windowManager.getDefaultDisplay();
                Method method = Display.class.getMethod("getRawHeight", new Class[0]);
                Method method2 = Display.class.getMethod("getRawWidth", new Class[0]);
                n2 = (Integer)method.invoke((Object)display, new Object[0]);
                n = (Integer)method2.invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Size(n, n2);
    }

    public static int getScreenOrientation(Context context) {
        return context.getResources().getConfiguration().orientation;
    }

    public static float getDensity(Context context) {
        return ScreenHelper.getInstance(context).a();
    }

    private float a() {
        if (this.f == null) {
            this.f = Float.valueOf(ScreenHelper.a((Context)this.g).density);
        }
        return this.f.floatValue();
    }

    @SuppressLint(value={"NewApi"})
    public static boolean isScreenOn(Context context) {
        return ScreenHelper.getInstance(context).b();
    }

    private boolean b() {
        if (this.a != null) {
            return this.a;
        }
        PowerManager powerManager = (PowerManager)this.g.getSystemService("power");
        if (Build.VERSION.SDK_INT < 20) {
            return powerManager.isScreenOn();
        }
        return powerManager.isInteractive();
    }

    private static DisplayMetrics a(Context context) {
        return context.getResources().getDisplayMetrics();
    }

    public static boolean addScreenStateListener(Context context, ScreenStateListener listener) {
        return ScreenHelper.getInstance(context).a(listener);
    }

    private boolean a(ScreenStateListener screenStateListener) {
        boolean bl;
        boolean bl2 = bl = this.mListeners != null || this.registerBroadcastReceiver();
        if (bl) {
            if (this.mListeners == null) {
                this.mListeners = new CopyOnWriteArraySet();
            }
            return this.mListeners.add(screenStateListener);
        }
        return false;
    }

    @VisibleForTesting
    protected boolean registerBroadcastReceiver() {
        try {
            if (this.b == null) {
                this.b = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        if (intent == null) {
                            return;
                        }
                        boolean bl = "android.intent.action.USER_PRESENT".equals(intent.getAction());
                        if (ScreenHelper.this.a == null || ScreenHelper.this.a != bl) {
                            ScreenHelper.this.a = bl;
                            ScreenHelper.this.a(bl);
                        }
                    }
                };
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.USER_PRESENT");
                intentFilter.addAction("android.intent.action.SCREEN_OFF");
                if (this.c.compareAndSet(false, true)) {
                    this.g.registerReceiver(this.b, intentFilter);
                }
            }
        }
        catch (Exception exception) {
            this.c.set(false);
            return false;
        }
        return true;
    }

    private void a(boolean bl) {
        if (this.mListeners != null) {
            for (ScreenStateListener screenStateListener : this.mListeners) {
                screenStateListener.onScreenStateChanged(bl);
            }
        }
    }

    public static boolean removeScreenStateListener(Context context, ScreenStateListener listener) {
        return ScreenHelper.getInstance(context).b(listener);
    }

    private boolean b(ScreenStateListener screenStateListener) {
        if (this.mListeners == null) {
            return false;
        }
        boolean bl = this.mListeners.remove(screenStateListener);
        if (this.mListeners.isEmpty()) {
            this.mListeners = null;
            return this.c();
        }
        return bl;
    }

    private boolean c() {
        try {
            if (this.c.compareAndSet(true, false)) {
                this.g.unregisterReceiver(this.b);
            }
            this.b = null;
            this.a = null;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public static synchronized void reset() {
        if (e != null) {
            if (ScreenHelper.e.c.compareAndSet(true, false)) {
                ScreenHelper.e.g.unregisterReceiver(ScreenHelper.e.b);
            }
            ScreenHelper.e.f = null;
            ScreenHelper.e.a = null;
            ScreenHelper.e.mListeners = null;
            ScreenHelper.e.b = null;
            e = null;
        }
    }

    public static interface ScreenStateListener {
        public void onScreenStateChanged(boolean var1);
    }
}

