/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.schedulers.alarm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.inlocomedia.android.core.AppContext;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.schedulers.alarm.AlarmInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AlarmHelper {
    private static final String a = Logger.makeTag(AlarmHelper.class);
    public static final int ALARM_CODE_GEOFENCE_TRANSITION = 0;
    private static AlarmHelper b;
    private Map<Integer, AlarmInfo> c;

    public static synchronized AlarmHelper getInstance(Context context) {
        if (b == null) {
            b = new AlarmHelper(context);
        }
        return b;
    }

    private AlarmHelper(Context context) {
        AppContext.set(context);
        this.c = new ConcurrentHashMap<Integer, AlarmInfo>();
    }

    public static void reset() {
        b = null;
    }

    public static boolean enableAlarm(Context context, int alarmCode, @NonNull AlarmInfo alarmInfo) {
        return AlarmHelper.getInstance(context).enableAlarm(alarmCode, alarmInfo);
    }

    private static PendingIntent a(Context context, int n) {
        return AlarmHelper.getInstance(context).a(n);
    }

    public static void disableAlarm(Context context, int alarmCode) {
        AlarmHelper.getInstance(context).disableAlarm(alarmCode);
    }

    public static boolean isAlarmActivated(Context context, int alarmCode) {
        return AlarmHelper.getInstance(context).isAlarmActivated(alarmCode);
    }

    private PendingIntent a(int n) {
        return this.a(n, 0x8000000);
    }

    private PendingIntent a(int n, int n2) {
        AlarmInfo alarmInfo = this.c.get(n);
        if (alarmInfo != null) {
            Intent intent = new Intent(AppContext.get(), alarmInfo.getReceiver());
            intent.setAction(alarmInfo.getAction());
            intent.setPackage(AppContext.get().getPackageName());
            if (alarmInfo.getExtras() != null) {
                intent.putExtras(alarmInfo.getExtras());
            }
            return PendingIntent.getBroadcast((Context)AppContext.get(), (int)n, (Intent)intent, (int)n2);
        }
        return null;
    }

    @VisibleForTesting(otherwise=2)
    public boolean enableAlarm(int alarmCode, @NonNull AlarmInfo alarmInfo) {
        this.c.put(alarmCode, alarmInfo);
        long l = alarmInfo.getLatency() + SystemClock.elapsedRealtime();
        if (l >= SystemClock.elapsedRealtime()) {
            AlarmManager alarmManager = (AlarmManager)AppContext.get().getSystemService("alarm");
            if (alarmInfo.a()) {
                alarmManager.setRepeating(2, l, alarmInfo.getInterval(), this.a(alarmCode));
            } else {
                alarmManager.set(2, l, this.a(alarmCode));
            }
            this.a(l, alarmInfo);
            return true;
        }
        this.disableAlarm(alarmCode);
        return false;
    }

    private void a(long l, AlarmInfo alarmInfo) {
    }

    @VisibleForTesting(otherwise=2)
    public void disableAlarm(int alarmCode) {
        if (this.isAlarmActivated(alarmCode)) {
            PendingIntent pendingIntent = AlarmHelper.a(AppContext.get(), alarmCode);
            AlarmManager alarmManager = (AlarmManager)AppContext.get().getSystemService("alarm");
            alarmManager.cancel(pendingIntent);
            pendingIntent.cancel();
            this.c.remove(alarmCode);
        }
    }

    @VisibleForTesting(otherwise=2)
    public boolean isAlarmActivated(int alarmCode) {
        return this.a(alarmCode, 0x20000000) != null;
    }
}

