/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.schedulers;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.inlocomedia.android.core.AppContext;
import com.inlocomedia.android.core.schedulers.TaskInfo;
import com.inlocomedia.android.core.schedulers.alarm.AlarmHelper;
import com.inlocomedia.android.core.schedulers.alarm.AlarmInfo;
import com.inlocomedia.android.core.schedulers.job_scheduler.JobSchedulerWrapper;
import java.util.concurrent.atomic.AtomicReference;

public class Scheduler {
    private static final AtomicReference<Scheduler> a = new AtomicReference();
    @VisibleForTesting
    protected JobSchedulerWrapper mJobSchedulerWrapper;

    @VisibleForTesting
    Scheduler(@NonNull Context context) {
        AppContext.set(context);
        this.mJobSchedulerWrapper = new JobSchedulerWrapper();
    }

    public static Scheduler getInstance(@NonNull Context context) {
        Scheduler scheduler = a.get();
        if (scheduler == null) {
            a.compareAndSet(null, new Scheduler(context));
            scheduler = a.get();
        }
        return scheduler;
    }

    public static boolean schedule(@NonNull Context context, TaskInfo taskInfo) {
        return Scheduler.getInstance(context).a(taskInfo);
    }

    public static void cancel(@NonNull Context context, TaskInfo taskInfo) {
        Scheduler.getInstance(context).b(taskInfo);
    }

    public static boolean isTaskScheduled(@NonNull Context context, TaskInfo taskInfo) {
        return Scheduler.getInstance(context).c(taskInfo);
    }

    private boolean a(TaskInfo taskInfo) {
        if (this.a()) {
            return this.g(taskInfo);
        }
        return this.d(taskInfo);
    }

    private void b(TaskInfo taskInfo) {
        if (this.a()) {
            this.h(taskInfo);
        } else {
            this.e(taskInfo);
        }
    }

    private boolean c(TaskInfo taskInfo) {
        if (this.a()) {
            return this.i(taskInfo);
        }
        return this.f(taskInfo);
    }

    private boolean d(TaskInfo taskInfo) {
        AlarmInfo alarmInfo = AlarmInfo.fromTaskInfo(taskInfo);
        return AlarmHelper.enableAlarm(AppContext.get(), taskInfo.getAlarmCode(), alarmInfo);
    }

    private void e(TaskInfo taskInfo) {
        AlarmHelper.disableAlarm(AppContext.get(), taskInfo.getAlarmCode());
    }

    private boolean f(TaskInfo taskInfo) {
        return AlarmHelper.isAlarmActivated(AppContext.get(), taskInfo.getAlarmCode());
    }

    private boolean g(TaskInfo taskInfo) {
        return false;
    }

    private void h(TaskInfo taskInfo) {
    }

    private boolean i(TaskInfo taskInfo) {
        return false;
    }

    @VisibleForTesting
    boolean a() {
        return false;
    }

    @VisibleForTesting(otherwise=5)
    public static void reset() {
        a.set(null);
    }
}

