/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.inlocomedia.android.core.AppContext;
import com.inlocomedia.android.core.communication.exception.NetworkUnavailableException;
import com.inlocomedia.android.core.util.Validator;

public final class NetworkAccessTools {
    public NetworkAccessTools(Context context) {
        AppContext.set(context);
    }

    public boolean isNetworkAvailable() {
        return NetworkAccessTools.isNetworkAvailable(AppContext.get());
    }

    public boolean isConnectedViaWifi() {
        return NetworkAccessTools.isConnectedViaWifi(AppContext.get());
    }

    public NetworkInfo getActiveNetworkInfo() {
        return NetworkAccessTools.getActiveNetworkInfo(AppContext.get());
    }

    public static void validateNetworkAvailable() throws NetworkUnavailableException {
        NetworkAccessTools.validateNetworkAvailable(AppContext.get());
    }

    public static boolean isNetworkAvailable(Context context) {
        Validator.notNull(context, "Context");
        NetworkInfo networkInfo = NetworkAccessTools.getActiveNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnectedOrConnecting();
    }

    public static boolean isConnectedViaWifi(Context context) {
        Validator.notNull(context, "Context");
        NetworkInfo networkInfo = NetworkAccessTools.getActiveNetworkInfo(context);
        return networkInfo != null && networkInfo.getType() == 1 && networkInfo.isConnectedOrConnecting();
    }

    public static NetworkInfo getActiveNetworkInfo(Context context) {
        Validator.notNull(context, "Context");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivityManager.getActiveNetworkInfo();
    }

    public static void validateNetworkAvailable(Context context) throws NetworkUnavailableException {
        Validator.notNull(context, "Context");
        if (!NetworkAccessTools.isNetworkAvailable(context)) {
            throw new NetworkUnavailableException();
        }
    }
}

