/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication;

import android.content.Context;
import android.os.SystemClock;
import com.inlocomedia.android.core.communication.AuthRequestBuilder;
import com.inlocomedia.android.core.communication.AuthenticationToken;
import com.inlocomedia.android.core.communication.RequestOverview;
import com.inlocomedia.android.core.communication.a;
import com.inlocomedia.android.core.communication.builders.BaseAuthenticationRequestBuilder;
import com.inlocomedia.android.core.communication.builders.HttpRequestBuilder;
import com.inlocomedia.android.core.communication.exception.TimeoutException;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.communication.requests.params.HttpRequestParams;
import com.inlocomedia.android.core.communication.responses.UrlResponse;
import com.inlocomedia.android.core.communication.util.HttpClientFactory;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.exception.InLocoMediaUnhandledException;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.core.util.time.TimeProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public final class Communication {
    private Communication() {
    }

    public static <T> T executeSync(HttpRequestBuilder<T> builder) throws InLocoMediaException {
        return Communication.a(builder, 0L);
    }

    static <T> T a(HttpRequestBuilder<T> httpRequestBuilder, long l) throws InLocoMediaException {
        final a<T> a2 = new a<T>(httpRequestBuilder);
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return Communication.b(a2);
            }
        };
        try {
            Object object;
            if (l == 0L) {
                object = callable.call();
            } else {
                Future future = ThreadPool.submit(callable);
                object = future.get(l, TimeUnit.MILLISECONDS);
            }
            a2.a();
            return (T)object;
        }
        catch (Throwable throwable) {
            a2.a();
            throw Communication.b(throwable);
        }
    }

    public static <T> a<T> executeAsync(HttpRequestBuilder<T> builder, RequestListener<T> listener) {
        return Communication.a(builder, listener, 0L, false);
    }

    public static <T> a<T> executeAsync(HttpRequestBuilder<T> builder, RequestListener<T> listener, long timeout, TimeUnit timeUnit) {
        return Communication.executeAsync(builder, listener, timeUnit != TimeUnit.MILLISECONDS ? timeUnit.toMillis(timeout) : timeout);
    }

    public static <T> a<T> executeAsync(HttpRequestBuilder<T> builder, RequestListener<T> listener, long timeout) {
        return Communication.a(builder, listener, timeout, false);
    }

    public static <T> a executeWithThreadLimit(HttpRequestBuilder<T> builder, RequestListener<T> listener) {
        return Communication.a(builder, listener, 0L, true);
    }

    private static <T> a<T> a(HttpRequestBuilder<T> httpRequestBuilder, final RequestListener<T> requestListener, final long l, boolean bl) {
        a a2;
        block3: {
            a2 = new a(httpRequestBuilder);
            try {
                Callable callable = new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        Object object = null;
                        InLocoMediaException inLocoMediaException = null;
                        try {
                            object = Communication.b(a2);
                        }
                        catch (InLocoMediaException inLocoMediaException2) {
                            inLocoMediaException = Communication.b(inLocoMediaException2);
                        }
                        if (l == 0L && a2.d() && requestListener != null) {
                            if (inLocoMediaException == null) {
                                requestListener.onRequestFinished(object);
                            } else {
                                requestListener.onRequestFailed(inLocoMediaException);
                            }
                        }
                        if (inLocoMediaException != null) {
                            throw inLocoMediaException;
                        }
                        return object;
                    }
                };
                final Future future = ThreadPool.submit(callable, bl);
                a2.a(future);
                if (l > 0L) {
                    ThreadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    Object v = future.get(l, TimeUnit.MILLISECONDS);
                                    if (a2.d() && requestListener != null) {
                                        requestListener.onRequestFinished(v);
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (!a2.d() || requestListener == null) break block3;
                                    InLocoMediaException inLocoMediaException = Communication.b(throwable);
                                    requestListener.onRequestFailed(inLocoMediaException);
                                }
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                if (!a2.d() || requestListener == null) break block3;
                InLocoMediaException inLocoMediaException = Communication.b(throwable);
                requestListener.onRequestFailed(inLocoMediaException);
            }
        }
        return a2;
    }

    private static <T> T b(a<T> a2) throws InLocoMediaException {
        try {
            Object object;
            long l = SystemClock.elapsedRealtime();
            a2.e();
            AuthRequestBuilder<?> authRequestBuilder = a2.g().getAuthenticationBuilder();
            if (a2.g().isAuthEnabled() && (object = a2.g().getAuthenticationBuilder().getAuthenticationToken()) != null && Validator.isNullOrEmpty(((AuthenticationToken)object).getToken())) {
                Communication.a(authRequestBuilder, a2);
                return Communication.b(a2);
            }
            object = a2.g().build();
            if (authRequestBuilder != null) {
                authRequestBuilder.addTokenToRequest((HttpRequestParams)object);
            }
            a2.a(HttpClientFactory.newHttpClientRequest((HttpRequestParams)object, a2.g().getErrorHandler()));
            UrlResponse urlResponse = a2.h().run();
            T t = null;
            if (urlResponse.isUnauthorized() && authRequestBuilder != null && authRequestBuilder.isAuthEnabled()) {
                Communication.a(authRequestBuilder, a2);
                return Communication.b(a2);
            }
            if (urlResponse.isSuccessful()) {
                try {
                    t = a2.g().convert(urlResponse.getData());
                }
                catch (Throwable throwable) {
                    a2.h().removeCached();
                    urlResponse.setErrorReceived(new InLocoMediaUnhandledException(throwable));
                }
            }
            long l2 = SystemClock.elapsedRealtime() - l;
            TimeProvider timeProvider = TimeProvider.getInstance();
            RequestOverview requestOverview = new RequestOverview((HttpRequestParams)object, urlResponse, l2, timeProvider.currentTimeMillis());
            a2.g().handleRequestOverview(requestOverview);
            if (urlResponse.isSuccessful()) {
                return t;
            }
            throw urlResponse.getErrorReceived();
        }
        catch (InLocoMediaException inLocoMediaException) {
            throw inLocoMediaException;
        }
        catch (Throwable throwable) {
            throw new InLocoMediaUnhandledException(throwable);
        }
    }

    public static AuthRequestBuilder<JSONObject> getBaseAuthenticationBuilder(Context context, AuthenticationToken token) {
        return new BaseAuthenticationRequestBuilder(context, token);
    }

    private static <T> void a(AuthRequestBuilder<T> authRequestBuilder, a<?> a2) throws InLocoMediaException {
        authRequestBuilder.setErrorHandlerManager(a2.g().getErrorHandler());
        a<T> a3 = new a<T>(authRequestBuilder);
        T t = Communication.b(a3);
        a2.g().disableAuth();
        authRequestBuilder.onAuthCompleted(t);
    }

    private static InLocoMediaException b(Throwable throwable) {
        if (throwable instanceof RejectedExecutionException) {
            return new InLocoMediaException("Communication ThreadPool rejected request", throwable);
        }
        if (throwable instanceof java.util.concurrent.TimeoutException | throwable instanceof InterruptedException) {
            return new TimeoutException("Request reached timeout");
        }
        if (throwable instanceof InLocoMediaException) {
            return (InLocoMediaException)throwable;
        }
        if (throwable instanceof ExecutionException) {
            Throwable throwable2;
            Throwable throwable3 = throwable2 = throwable.getCause() != null ? throwable.getCause() : throwable;
            if (throwable2 instanceof InLocoMediaException) {
                return (InLocoMediaException)throwable2;
            }
            return new InLocoMediaUnhandledException(throwable2);
        }
        return new InLocoMediaUnhandledException(throwable);
    }
}

