/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.permissions;

import android.content.Context;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import com.inlocomedia.android.core.AppContext;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.data.local.SharedPreferencesManager;
import com.inlocomedia.android.core.log.CriticalErrorManager;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.permissions.PermissionResult;
import com.inlocomedia.android.core.permissions.PermissionsFragment;
import com.inlocomedia.android.core.permissions.PermissionsListener;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;

public final class PermissionsManager {
    private final String a = Logger.makeTag(PermissionsManager.class);
    private ArrayDeque<a> b = new ArrayDeque();
    private boolean c = false;
    private static PermissionsManager d;

    private PermissionsManager() {
    }

    public static synchronized PermissionsManager getInstance() {
        if (d == null) {
            d = new PermissionsManager();
        }
        return d;
    }

    public void requestPermissions(final Context context, final String[] permissions, final boolean askIfDenied, final PermissionsListener listener) {
        ThreadPool.executeInMain(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!Validator.isValidSDKVersion() && !Environment.CoreModulesManager.PERMISSIONS.isValid()) {
                        return;
                    }
                    AppContext.set(context);
                    a a2 = new a(permissions, listener, askIfDenied);
                    PermissionsManager.this.b.add(a2);
                    if (!PermissionsManager.this.c) {
                        PermissionsManager.this.a();
                    }
                }
                catch (Throwable throwable) {
                    CriticalErrorManager.notifyError(PermissionsManager.this.a, throwable, Environment.CoreModulesManager.PERMISSIONS);
                }
            }
        });
    }

    public static boolean permissionDeniedForever(Context context, String permission2) {
        return PermissionsManager.a(context, permission2) == com.inlocomedia.android.core.permissions.PermissionsManager$b.b.a();
    }

    private void a() {
        if (!Validator.isValidSDKVersion() && !Environment.CoreModulesManager.PERMISSIONS.isValid()) {
            return;
        }
        if (this.b.isEmpty()) {
            return;
        }
        a a2 = this.b.peek();
        this.c = true;
        ArrayList<String> arrayList = new ArrayList<String>(a2.b.length);
        Context context = AppContext.get();
        for (String string : a2.b) {
            int n = PermissionsManager.a(context, string);
            if (this.isPermissionEnabled(context, string)) {
                if (n != com.inlocomedia.android.core.permissions.PermissionsManager$b.d.a()) {
                    PermissionsManager.a(context, string, com.inlocomedia.android.core.permissions.PermissionsManager$b.d);
                }
                a2.d.put(string, new PermissionResult(true, false));
                continue;
            }
            if (PermissionsManager.b() && n != com.inlocomedia.android.core.permissions.PermissionsManager$b.b.a() && a2.e) {
                arrayList.add(string);
            }
            a2.d.put(string, new PermissionResult(false, false));
        }
        if (arrayList.isEmpty()) {
            this.c();
        } else {
            PermissionsFragment.a(context, arrayList.toArray(new String[arrayList.size()]));
        }
    }

    public boolean isPermissionEnabled(Context context, String permission2) {
        int n = ContextCompat.checkSelfPermission((Context)context, (String)permission2);
        return n == 0;
    }

    void a(String[] stringArray, boolean[] blArray, boolean[] blArray2) {
        try {
            a a2 = this.b.peek();
            Context context = AppContext.get();
            if (a2 != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    PermissionResult permissionResult;
                    boolean bl = ((PermissionResult)a2.d.get(stringArray[i])).isAuthorized();
                    if (blArray[i]) {
                        PermissionsManager.a(context, stringArray[i], com.inlocomedia.android.core.permissions.PermissionsManager$b.d);
                        permissionResult = new PermissionResult(true, !bl);
                        a2.d.put(stringArray[i], permissionResult);
                        continue;
                    }
                    if (blArray2[i]) {
                        PermissionsManager.a(context, stringArray[i], com.inlocomedia.android.core.permissions.PermissionsManager$b.c);
                        permissionResult = new PermissionResult(false, bl);
                        a2.d.put(stringArray[i], permissionResult);
                        continue;
                    }
                    PermissionsManager.a(context, stringArray[i], com.inlocomedia.android.core.permissions.PermissionsManager$b.b);
                    permissionResult = new PermissionResult(false, bl);
                    a2.d.put(stringArray[i], permissionResult);
                }
            }
            this.c();
        }
        catch (Throwable throwable) {
            CriticalErrorManager.notifyError(this.a, throwable, Environment.CoreModulesManager.PERMISSIONS);
        }
    }

    private static boolean b() {
        return Build.VERSION.SDK_INT >= 23;
    }

    private void c() {
        final a a2 = this.b.poll();
        if (a2 != null) {
            ThreadPool.postOnMain(new Runnable(){

                @Override
                public void run() {
                    a2.c.onPermissionRequestCompleted(a2.d);
                }
            });
        }
        this.c = false;
        this.a();
    }

    private static SharedPreferencesManager.Entry a(Context context) {
        return SharedPreferencesManager.getInstance(context).getEntry("com.inlocomedia.android.core.permissions.PermissionsManager");
    }

    private static void a(Context context, String string, b b2) {
        PermissionsManager.a(context).put(string, b2.a()).commit();
    }

    private static int a(Context context, String string) {
        return PermissionsManager.a(context).getInt(string, com.inlocomedia.android.core.permissions.PermissionsManager$b.a.a());
    }

    private class a {
        private String[] b;
        private PermissionsListener c;
        private HashMap<String, PermissionResult> d;
        private boolean e;

        a(String[] stringArray, PermissionsListener permissionsListener, boolean bl) {
            this.b = stringArray;
            this.c = permissionsListener;
            this.d = new HashMap();
            this.e = bl;
        }
    }

    private static enum b {
        a(-2),
        b(-1),
        c(0),
        d(1);

        private final Integer e;

        private b(int n2) {
            this.e = n2;
        }

        public Integer a() {
            return this.e;
        }

        public String toString() {
            return this.e.toString();
        }
    }
}

