/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.data.local.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.support.annotation.VisibleForTesting;
import android.util.SparseArray;
import com.inlocomedia.android.core.communication.util.BinaryUtils;
import com.inlocomedia.android.core.data.local.Storage;
import com.inlocomedia.android.core.data.local.StorageEntry;
import com.inlocomedia.android.core.data.local.database.LazyCloseSQLiteOpenHelper;
import com.inlocomedia.android.core.data.local.database.SQLiteDatabaseListener;
import com.inlocomedia.android.core.data.local.database.SQLiteDatabaseWrapper;
import com.inlocomedia.android.core.data.local.database.StorageOperation;
import com.inlocomedia.android.core.log.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DatabaseStorage
implements Storage,
SQLiteDatabaseListener {
    private static final String a = Logger.makeTag(DatabaseStorage.class);
    private int b;
    private LazyCloseSQLiteOpenHelper c;
    private Listener d;

    public DatabaseStorage(LazyCloseSQLiteOpenHelper lazyCloseSQLiteOpenHelper, int databaseMaxRows) {
        this(lazyCloseSQLiteOpenHelper, databaseMaxRows, null);
    }

    public DatabaseStorage(LazyCloseSQLiteOpenHelper lazyCloseSQLiteOpenHelper, int databaseMaxRows, Listener listener) {
        this.c = lazyCloseSQLiteOpenHelper;
        this.c.setDatabaseListener(this);
        this.b = databaseMaxRows;
        this.d = listener;
    }

    @Override
    public synchronized boolean insert(int id, Map<String, Serializable> values) {
        StorageEntry storageEntry = new StorageEntry();
        long l = System.currentTimeMillis();
        storageEntry.add(l, values);
        boolean bl = this.a(id, storageEntry);
        String string = bl ? "Values saved successfully: " : "Failure saving values: ";
        return bl;
    }

    @Override
    public synchronized void trim() {
        StorageOperation.Builder builder = new StorageOperation.Builder().setOperation(2);
        if (this.d != null) {
            this.a(builder);
        }
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.c.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return;
            }
            long l = sQLiteDatabaseWrapper.queryNumEntries("events");
            if (l > (long)this.b) {
                long l2 = l - (long)this.b;
                sQLiteDatabaseWrapper.execSQL(this.a(l2));
            }
            this.c.closeDatabase();
        }
        catch (Throwable throwable) {
            this.c.onUnexpectedError(throwable);
        }
        if (this.d != null) {
            this.b(builder);
            this.d.onOperationPerformed(builder.build());
        }
    }

    @Override
    public synchronized void clean() {
        try {
            this.a();
        }
        catch (Throwable throwable) {
            this.c.onUnexpectedError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SparseArray<StorageEntry> dump() {
        try (Cursor cursor = null;){
            SparseArray sparseArray = new SparseArray();
            cursor = this.b();
            if (cursor != null) {
                int n = cursor.getColumnIndex("event_id");
                int n2 = cursor.getColumnIndex("timestamp");
                int n3 = cursor.getColumnIndex("event_values");
                while (cursor.moveToNext()) {
                    int n4 = cursor.getInt(n);
                    long l = cursor.getLong(n2);
                    byte[] byArray = cursor.getBlob(n3);
                    StorageEntry storageEntry = (StorageEntry)sparseArray.get(n4);
                    if (storageEntry == null) {
                        storageEntry = new StorageEntry();
                        sparseArray.put(n4, (Object)storageEntry);
                    }
                    storageEntry.add(l, (Map)BinaryUtils.fromByteArray(byArray));
                }
            }
            this.a();
            SparseArray sparseArray2 = sparseArray;
            return sparseArray2;
        }
    }

    @Override
    public synchronized void onCreate(SQLiteDatabaseWrapper databaseWrapper) {
        try {
            databaseWrapper.execSQL("CREATE TABLE events(_id INTEGER PRIMARY KEY AUTOINCREMENT, timestamp INTEGER, event_id INTEGER NOT NULL, event_values BLOB); ");
        }
        catch (Throwable throwable) {
            this.c.onUnexpectedError(throwable);
        }
    }

    @Override
    public synchronized void onUpgrade(SQLiteDatabaseWrapper databaseWrapper, int oldVersion, int newVersion) {
        this.a(databaseWrapper);
    }

    @Override
    public synchronized void onDowngrade(SQLiteDatabaseWrapper databaseWrapper, int oldVersion, int newVersion) {
        this.a(databaseWrapper);
    }

    private void a(SQLiteDatabaseWrapper sQLiteDatabaseWrapper) {
        try {
            sQLiteDatabaseWrapper.execSQL("DROP TABLE IF EXISTS events");
            this.onCreate(sQLiteDatabaseWrapper);
        }
        catch (Throwable throwable) {
            this.c.onUnexpectedError(throwable);
        }
    }

    private void a() {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.c.openDatabase();
        if (sQLiteDatabaseWrapper != null) {
            sQLiteDatabaseWrapper.deleteAll("events");
        }
        this.c.closeDatabase();
    }

    private boolean a(int n, StorageEntry storageEntry) {
        boolean bl = true;
        List<Map<String, Serializable>> list = storageEntry.getValuesList();
        for (Map<String, Serializable> map : list) {
            bl &= this.a(n, map, storageEntry.getTimestampFromValues(map));
        }
        return bl;
    }

    private boolean a(int n, Map<String, Serializable> map, long l) {
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.c.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return false;
            }
            ContentValues contentValues = this.b(n, map, l);
            long l2 = sQLiteDatabaseWrapper.insert("events", contentValues);
            this.c.closeDatabase();
            return l2 > 0L;
        }
        catch (Throwable throwable) {
            this.c.onUnexpectedError(throwable);
            return false;
        }
    }

    private ContentValues b(int n, Map<String, Serializable> map, long l) throws IOException {
        ContentValues contentValues = new ContentValues();
        contentValues.put("event_id", Integer.valueOf(n));
        contentValues.put("timestamp", Long.valueOf(l));
        byte[] byArray = BinaryUtils.toByteArray(map);
        contentValues.put("event_values", byArray);
        return contentValues;
    }

    private Cursor b() {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.c.openDatabase();
        if (sQLiteDatabaseWrapper == null) {
            return null;
        }
        Cursor cursor = sQLiteDatabaseWrapper.queryAll("events");
        this.c.closeDatabase();
        return cursor;
    }

    private void a(StorageOperation.Builder builder) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.c.openDatabase();
        if (sQLiteDatabaseWrapper == null) {
            return;
        }
        builder.setStorageName(sQLiteDatabaseWrapper.getDatabaseName()).setStorageVersion(sQLiteDatabaseWrapper.getDatabaseVersion()).setEntriesBefore(sQLiteDatabaseWrapper.queryNumEntries("events")).setSizeBefore(sQLiteDatabaseWrapper.getDatabaseSize());
        this.c.closeDatabase();
    }

    private void b(StorageOperation.Builder builder) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.c.openDatabase();
        if (sQLiteDatabaseWrapper == null) {
            return;
        }
        builder.setEntriesAfter(sQLiteDatabaseWrapper.queryNumEntries("events")).setSizeAfter(sQLiteDatabaseWrapper.getDatabaseSize());
        this.c.closeDatabase();
    }

    @VisibleForTesting(otherwise=2)
    String a(long l) {
        String string = "SELECT event_id FROM events ORDER BY timestamp ASC LIMIT " + l;
        String string2 = "DELETE FROM %s WHERE %s IN (" + string + ");";
        return String.format(string2, "events", "event_id");
    }

    public void setListener(Listener listener) {
        this.d = listener;
    }

    public static interface Listener {
        public void onOperationPerformed(StorageOperation var1);
    }
}

