/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.data.local;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.VisibleForTesting;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.Validator;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SharedPreferencesManager {
    private static final String b = Logger.makeTag(SharedPreferencesManager.class);
    @VisibleForTesting
    SharedPreferences a;
    private static SharedPreferencesManager c;
    private ConcurrentHashMap<String, Entry> d = new ConcurrentHashMap();
    private Context e;

    private SharedPreferencesManager(Context context) {
        this.e = context.getApplicationContext();
        this.a = context.getSharedPreferences("SDK_SHARED_PREFERENCES", 0);
    }

    public static synchronized SharedPreferencesManager getInstance(Context context) {
        if (c == null) {
            c = new SharedPreferencesManager(context);
        }
        return c;
    }

    @VisibleForTesting
    void a() {
        this.d = new ConcurrentHashMap();
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public Entry getEntry(String key) {
        if (key == null) {
            return null;
        }
        Entry entry = this.d.get(key);
        if (entry == null) {
            String string = this.a.getString(key, null);
            if (string != null) {
                ConcurrentHashMap<String, Object> concurrentHashMap = com.inlocomedia.android.core.data.local.SharedPreferencesManager$a.a(string);
                if (concurrentHashMap != null) {
                    entry = new Entry(key, this.a.edit(), concurrentHashMap);
                    this.d.put(key, entry);
                }
            } else if (SharedPreferencesManager.a(key, this.e.getPackageName())) {
                SharedPreferences sharedPreferences = this.e.getSharedPreferences(key, 0);
                entry = this.a(sharedPreferences, key);
                this.d.put(key, entry);
                if (entry.commit()) {
                    SharedPreferencesManager.b(sharedPreferences.edit().clear());
                    SharedPreferencesManager.b(key, this.e.getPackageName());
                }
            } else {
                entry = new Entry(key, this.a.edit());
                this.d.put(key, entry);
            }
        } else {
            SharedPreferencesManager.b(key, this.e.getPackageName());
        }
        return entry;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    @VisibleForTesting
    Entry a(SharedPreferences sharedPreferences, String string) {
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        Map map = sharedPreferences.getAll();
        for (Map.Entry entry : map.entrySet()) {
            String string2 = (String)entry.getKey();
            Object v = entry.getValue();
            if (string2 == null || v == null) continue;
            concurrentHashMap.put(string2, v);
        }
        return new Entry(string, this.a.edit(), concurrentHashMap);
    }

    @VisibleForTesting
    static boolean a(String string, String string2) {
        File file = new File(String.format("/data/data/%s/shared_prefs/%s.xml", string2, string));
        return file.exists();
    }

    private static void b(String string, String string2) {
        File file = new File(String.format("/data/data/%s/shared_prefs/%s.xml", string2, string));
        if (file.exists()) {
            boolean bl = file.delete();
        }
    }

    private static boolean b(SharedPreferences.Editor editor) {
        if (Validator.isMainThread()) {
            editor.apply();
            return true;
        }
        return editor.commit();
    }

    @SuppressLint(value={"CommitPrefEdits"})
    @VisibleForTesting
    public static void reset(Context context) {
        if (c != null) {
            c.a();
            SharedPreferencesManager.b(SharedPreferencesManager.c.a.edit().clear());
            SharedPreferencesManager.b("SDK_SHARED_PREFERENCES", context.getPackageName());
            c = null;
        }
    }

    static class a {
        private static final String a = Logger.makeTag(a.class);

        a() {
        }

        static String a(ConcurrentHashMap<String, Object> concurrentHashMap) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : concurrentHashMap.entrySet()) {
                Object object = entry.getValue();
                try {
                    stringBuilder.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append(":");
                    if (object != null && object instanceof String) {
                        stringBuilder.append('\"').append(URLEncoder.encode(object.toString(), "UTF-8")).append('\"');
                    } else {
                        stringBuilder.append(object);
                    }
                    stringBuilder.append(";");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
            return stringBuilder.toString();
        }

        static ConcurrentHashMap<String, Object> a(String string) {
            String[] stringArray;
            ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
            for (String string2 : stringArray = string.split(";")) {
                String[] stringArray2 = string2.split(":");
                try {
                    if (stringArray2.length != 2) continue;
                    if (stringArray2[1].length() >= 2 && stringArray2[1].charAt(0) == '\"') {
                        concurrentHashMap.put(URLDecoder.decode(stringArray2[0], "UTF-8"), URLDecoder.decode(stringArray2[1].substring(1, stringArray2[1].length() - 1), "UTF-8"));
                        continue;
                    }
                    concurrentHashMap.put(URLDecoder.decode(stringArray2[0], "UTF-8"), URLDecoder.decode(stringArray2[1], "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
            return concurrentHashMap;
        }

        static String a(Set<String> set) {
            if (set == null) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            for (String string : set) {
                try {
                    if (string == null) {
                        stringBuilder.append((String)null);
                        continue;
                    }
                    stringBuilder.append('\"').append(URLEncoder.encode(string, "UTF-8")).append('\"').append(",");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        static Set<String> b(String string) {
            if (string == null) {
                return null;
            }
            HashSet<String> hashSet = new HashSet<String>();
            if (string.startsWith("{") && string.endsWith("}")) {
                String[] stringArray;
                if (string.length() == 2) {
                    return hashSet;
                }
                String string2 = string.substring(1, string.length() - 1);
                for (String string3 : stringArray = string2.split(",")) {
                    try {
                        if (string3.equals("null")) {
                            hashSet.add(null);
                            continue;
                        }
                        if (string3.length() < 2 || string3.charAt(0) != '\"' || string3.charAt(string3.length() - 1) != '\"') continue;
                        hashSet.add(URLDecoder.decode(string3.substring(1, string3.length() - 1), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        return null;
                    }
                }
            }
            return hashSet;
        }
    }

    public static class Entry {
        private String a;
        private ConcurrentHashMap<String, Object> b;
        private SharedPreferences.Editor c;

        public Entry(String key, SharedPreferences.Editor editor) {
            this.a = key;
            this.c = editor;
            this.b = new ConcurrentHashMap();
        }

        public Entry(String key, SharedPreferences.Editor editor, ConcurrentHashMap<String, Object> hash) {
            this.a = key;
            this.c = editor;
            this.b = hash;
        }

        public String getKey() {
            return this.a;
        }

        public boolean isEmpty() {
            return this.b.size() == 0;
        }

        public int getInt(String key) {
            if (key == null) {
                return 0;
            }
            Object object = this.b.get(key);
            if (object instanceof String) {
                return Integer.parseInt((String)object);
            }
            return (Integer)object;
        }

        public int getInt(String key, int defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            if (object == null) {
                return defaultValue;
            }
            if (object instanceof String) {
                return Integer.parseInt((String)object);
            }
            return (Integer)object;
        }

        public Entry put(String key, int value) {
            if (key != null) {
                this.b.put(key, value);
            }
            return this;
        }

        public boolean getBoolean(String key) {
            if (key == null) {
                return false;
            }
            Object object = this.b.get(key);
            if (object instanceof String) {
                return Boolean.parseBoolean((String)object);
            }
            return (Boolean)object;
        }

        public boolean getBoolean(String key, boolean defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            if (object == null) {
                return defaultValue;
            }
            if (object instanceof String) {
                return Boolean.parseBoolean((String)object);
            }
            return (Boolean)object;
        }

        public Entry put(String key, boolean value) {
            if (key != null) {
                this.b.put(key, value);
            }
            return this;
        }

        public double getDouble(String key) {
            if (key == null) {
                return 0.0;
            }
            Object object = this.b.get(key);
            if (object instanceof String) {
                return Double.parseDouble((String)this.b.get(key));
            }
            return (Double)object;
        }

        public double getDouble(String key, double defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            if (object == null) {
                return defaultValue;
            }
            if (object instanceof String) {
                return Double.parseDouble((String)object);
            }
            return (Double)object;
        }

        public Entry put(String key, double value) {
            if (key != null) {
                this.b.put(key, value);
            }
            return this;
        }

        public float getFloat(String key, float defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            if (object == null) {
                return defaultValue;
            }
            if (object instanceof String) {
                return Float.parseFloat((String)object);
            }
            return ((Float)object).floatValue();
        }

        public Entry put(String key, float value) {
            if (key != null) {
                this.b.put(key, Float.valueOf(value));
            }
            return this;
        }

        public long getLong(String key) {
            if (key == null) {
                return 0L;
            }
            Object object = this.b.get(key);
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            return (Long)object;
        }

        public long getLong(String key, long defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            if (object == null) {
                return defaultValue;
            }
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            return (Long)object;
        }

        public Entry put(String key, long value) {
            if (key != null) {
                this.b.put(key, value);
            }
            return this;
        }

        public String getString(String key) {
            if (key == null) {
                return null;
            }
            return (String)this.b.get(key);
        }

        public String getString(String key, String defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            return object != null ? (String)object : defaultValue;
        }

        public Entry put(String key, String value) {
            if (key != null && value != null) {
                this.b.put(key, value);
            }
            return this;
        }

        Set<String> a(String string) {
            if (string == null) {
                return null;
            }
            return com.inlocomedia.android.core.data.local.SharedPreferencesManager$a.b((String)this.b.get(string));
        }

        public Set<String> getStringSet(String key, Set<String> defaultValue) {
            if (key == null) {
                return defaultValue;
            }
            Object object = this.b.get(key);
            if (object == null) {
                return defaultValue;
            }
            if (object instanceof String) {
                return this.a(key);
            }
            return defaultValue;
        }

        public Entry put(String key, Set<String> set) {
            if (key != null && set != null) {
                String string = com.inlocomedia.android.core.data.local.SharedPreferencesManager$a.a(set);
                this.b.put(key, string);
            }
            return this;
        }

        public Entry remove(String key) {
            if (key != null) {
                this.b.remove(key);
            }
            return this;
        }

        public boolean commit() {
            String string = com.inlocomedia.android.core.data.local.SharedPreferencesManager$a.a(this.b);
            if (string != null) {
                this.c.putString(this.a, string);
                return SharedPreferencesManager.b(this.c);
            }
            return false;
        }

        public boolean clear() {
            this.b.clear();
            if (this.c != null) {
                this.c.remove(this.a);
                return SharedPreferencesManager.b(this.c);
            }
            return false;
        }

        public boolean contains(String key) {
            return this.b != null && this.b.containsKey(key);
        }
    }
}

