/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import com.inlocomedia.android.core.exception.InvalidMappingException;
import com.inlocomedia.android.core.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public final class SerializationUtils {
    private static final String a = Logger.makeTag(SerializationUtils.class);

    private SerializationUtils() {
    }

    private static void a(Serializable serializable, OutputStream outputStream) throws InvalidMappingException {
        if (outputStream == null) {
            throw new InvalidMappingException("The OutputStream must not be null");
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
        }
        catch (IOException iOException) {
            throw new InvalidMappingException(serializable.getClass().getSimpleName() + " serialization has failed", iOException);
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] serialize(Serializable obj) throws InvalidMappingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationUtils.a(obj, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static <T> T a(InputStream inputStream) throws InvalidMappingException {
        Object object;
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        ObjectInputStream objectInputStream = null;
        try {
            Object object2;
            objectInputStream = new ObjectInputStream(inputStream);
            object = object2 = objectInputStream.readObject();
        }
        catch (IOException | ClassCastException | ClassNotFoundException exception) {
            throw new InvalidMappingException("Object serialization has failed" + exception);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return (T)object;
    }

    public static <T> T deserialize(byte[] objectData) throws InvalidMappingException {
        if (objectData == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        return SerializationUtils.a(new ByteArrayInputStream(objectData));
    }
}

