/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.util.Locale;

public final class IntentUtils {
    private IntentUtils() {
    }

    public static Intent getIntentForMainActivity(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = packageManager.getLaunchIntentForPackage(context.getPackageName());
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        return intent;
    }

    @NonNull
    public static Intent getIntentForUri(Context context, String uri) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        return intent;
    }

    @NonNull
    public static Intent getIntentForVideo(Context context, String videoUrl) {
        Intent intent = new Intent("android.intent.action.VIEW");
        String string = IntentUtils.a("video/*", MimeTypeMap.getFileExtensionFromUrl((String)videoUrl));
        intent.setDataAndType(Uri.parse((String)videoUrl), string);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        return intent;
    }

    @NonNull
    public static Intent getIntentForImage(Context context, Uri imageUri) {
        Intent intent = new Intent("android.intent.action.VIEW");
        String string = IntentUtils.a("image/*", MimeTypeMap.getFileExtensionFromUrl((String)imageUri.toString()));
        intent.setDataAndType(imageUri, string);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        return intent;
    }

    private static String a(@NonNull String string, @Nullable String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string;
        }
        return string.replace("*", string2).toLowerCase(Locale.US);
    }
}

