/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.serialization.json;

import com.inlocomedia.android.core.exception.InvalidMappingException;
import com.inlocomedia.android.core.serialization.ReflectionHelper;
import com.inlocomedia.android.core.serialization.json.Jsonable;
import com.inlocomedia.android.core.serialization.json.JsonableModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonReflector {
    private JsonReflector() {
    }

    static JSONObject a(Object object) throws InvalidMappingException {
        Field[] fieldArray;
        if (object == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        for (Field field : fieldArray = ReflectionHelper.getAllFields(object.getClass())) {
            JsonableModel.JsonField jsonField = field.getAnnotation(JsonableModel.JsonField.class);
            if (jsonField == null) continue;
            String string = jsonField.key();
            try {
                Object object2 = JsonReflector.a(object, field);
                if (object2 == null) continue;
                jSONObject.put(string, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException | JSONException throwable) {
                // empty catch block
            }
        }
        return jSONObject;
    }

    private static Object a(Object object, Field field) throws IllegalArgumentException, IllegalAccessException, InvalidMappingException {
        Class<?> clazz = field.getType();
        Object object2 = JsonReflector.a(clazz) ? JsonReflector.b(object, field) : (HashMap.class.isAssignableFrom(clazz) ? JsonReflector.d(object, field) : (Iterable.class.isAssignableFrom(clazz) ? JsonReflector.e(object, field) : JsonReflector.c(object, field)));
        return object2;
    }

    private static Object b(Object object, Field field) throws IllegalArgumentException, IllegalAccessException {
        return field.get(object);
    }

    private static Object c(Object object, Field field) throws IllegalArgumentException, IllegalAccessException, InvalidMappingException {
        Object object2 = field.get(object);
        if (object2 instanceof Jsonable) {
            return ((Jsonable)object2).parseToJSON();
        }
        return JsonReflector.a(object2);
    }

    private static JSONObject d(Object object, Field field) throws IllegalArgumentException, IllegalAccessException, InvalidMappingException {
        JSONObject jSONObject = null;
        HashMap hashMap = (HashMap)field.get(object);
        if (hashMap != null) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Class clazz = (Class)parameterizedType.getActualTypeArguments()[0];
            Class clazz2 = (Class)parameterizedType.getActualTypeArguments()[1];
            if (clazz != String.class) {
                throw new IllegalArgumentException("The keys of the hashmap must be of the type String.");
            }
            jSONObject = new JSONObject();
            for (Map.Entry entry : hashMap.entrySet()) {
                Object v = entry.getValue();
                try {
                    if (JsonReflector.a(clazz2)) {
                        jSONObject.put((String)entry.getKey(), v);
                        continue;
                    }
                    JSONObject jSONObject2 = JsonReflector.a(v);
                    jSONObject.put((String)entry.getKey(), (Object)jSONObject2);
                }
                catch (JSONException jSONException) {
                    throw new InvalidMappingException("Invalid key or child values to put in HashMap.", (Exception)((Object)jSONException));
                }
            }
        }
        return jSONObject;
    }

    private static JSONArray e(Object object, Field field) throws IllegalArgumentException, IllegalAccessException, InvalidMappingException {
        JSONArray jSONArray = null;
        Iterable iterable = (Iterable)field.get(object);
        if (iterable != null) {
            jSONArray = new JSONArray();
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Class clazz = (Class)parameterizedType.getActualTypeArguments()[0];
            for (Object t : iterable) {
                JSONObject jSONObject;
                if (JsonReflector.a(clazz)) {
                    jSONArray.put(t);
                    continue;
                }
                if (t instanceof Jsonable) {
                    jSONObject = ((Jsonable)t).parseToJSON();
                    jSONArray.put((Object)jSONObject);
                    continue;
                }
                jSONObject = JsonReflector.a(t);
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    static void a(JSONObject jSONObject, Object object) throws InvalidMappingException {
        Field[] fieldArray;
        for (Field field : fieldArray = ReflectionHelper.getAllFields(object.getClass())) {
            JsonableModel.JsonField jsonField = field.getAnnotation(JsonableModel.JsonField.class);
            if (jsonField == null) continue;
            String string = jsonField.key();
            try {
                if (field.getType() == List.class) {
                    JsonReflector.a(object, field, jSONObject.getJSONArray(string));
                    continue;
                }
                if (field.getType() == Set.class) {
                    JsonReflector.b(object, field, jSONObject.getJSONArray(string));
                    continue;
                }
                if (Collection.class.isAssignableFrom(field.getType())) {
                    JsonReflector.c(object, field, jSONObject.getJSONArray(string));
                    continue;
                }
                if (field.getType() == HashMap.class) {
                    JsonReflector.a(object, field, jSONObject.getJSONObject(string));
                    continue;
                }
                JsonReflector.a(object, field, jSONObject, string);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalArgumentException | InvocationTargetException exception) {
            }
            catch (JSONException jSONException) {
                if (jsonField.required()) {
                    throw new InvalidMappingException(field.getName() + " is required.", (Exception)((Object)jSONException));
                }
                if (jSONException.getMessage().contains("No value for")) continue;
            }
        }
    }

    private static void a(Object object, Field field, JSONObject jSONObject, String string) throws IllegalArgumentException, IllegalAccessException, InstantiationException, JSONException, InvalidMappingException, InvocationTargetException {
        Class<?> clazz = field.getType();
        Object object2 = JsonReflector.a(jSONObject, clazz, string);
        field.set(object, object2);
    }

    private static Object a(JSONObject jSONObject, Class<?> clazz, String string) throws InstantiationException, JSONException, InvalidMappingException, IllegalArgumentException, InvocationTargetException {
        Object object;
        if (clazz == String.class) {
            if (jSONObject.isNull(string)) {
                return null;
            }
            return jSONObject.getString(string);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return jSONObject.getBoolean(string);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return jSONObject.getInt(string);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return jSONObject.getDouble(string);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf((float)jSONObject.getDouble(string));
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return jSONObject.getLong(string);
        }
        if (jSONObject.isNull(string)) {
            object = null;
        } else {
            try {
                object = JsonReflector.b(clazz);
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            if (object instanceof Jsonable) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(string);
                ((Jsonable)object).parseFromJSON(jSONObject2);
            } else {
                throw new IllegalArgumentException("The field named " + string + " must be Jsonable");
            }
        }
        return object;
    }

    private static void a(Object object, Field field, JSONArray jSONArray) throws IllegalArgumentException, IllegalAccessException, InstantiationException, JSONException, InvalidMappingException {
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        Class clazz = (Class)parameterizedType.getActualTypeArguments()[0];
        field.set(object, JsonReflector.a(jSONArray, clazz));
    }

    private static List<?> a(JSONArray jSONArray, Class<?> clazz) throws IllegalAccessException, InstantiationException, JSONException, InvalidMappingException {
        Vector<Object> vector = new Vector<Object>(jSONArray.length());
        for (int i = 0; i < jSONArray.length(); ++i) {
            Object object = JsonReflector.a(clazz, jSONArray, i);
            vector.add(object);
        }
        return vector;
    }

    private static void b(Object object, Field field, JSONArray jSONArray) throws IllegalArgumentException, IllegalAccessException, InstantiationException, JSONException, InvalidMappingException {
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        Class clazz = (Class)parameterizedType.getActualTypeArguments()[0];
        field.set(object, JsonReflector.b(jSONArray, clazz));
    }

    private static Set<?> b(JSONArray jSONArray, Class<?> clazz) throws IllegalAccessException, InstantiationException, JSONException, InvalidMappingException {
        HashSet<Object> hashSet = new HashSet<Object>(jSONArray.length());
        for (int i = 0; i < jSONArray.length(); ++i) {
            Object object = JsonReflector.a(clazz, jSONArray, i);
            hashSet.add(object);
        }
        return hashSet;
    }

    private static void c(Object object, Field field, JSONArray jSONArray) throws IllegalArgumentException, IllegalAccessException, InstantiationException, JSONException, InvalidMappingException {
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        Class clazz = (Class)parameterizedType.getActualTypeArguments()[0];
        field.set(object, JsonReflector.a(jSONArray, clazz));
    }

    private static void a(Object object, Field field, JSONObject jSONObject) throws IllegalArgumentException, IllegalAccessException, InstantiationException, JSONException, InvalidMappingException {
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        Class clazz = (Class)parameterizedType.getActualTypeArguments()[1];
        field.set(object, JsonReflector.a(jSONObject, clazz));
    }

    private static HashMap<?, ?> a(JSONObject jSONObject, Class<?> clazz) throws IllegalAccessException, InstantiationException, JSONException, InvalidMappingException {
        HashMap<String, String> hashMap = new HashMap<String, String>(jSONObject.length());
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            List<?> list;
            String string = (String)iterator.next();
            if (clazz == String.class) {
                list = jSONObject.getString(string);
            } else if (clazz == Integer.TYPE || clazz == Integer.class) {
                list = jSONObject.getInt(string);
            } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                list = jSONObject.getBoolean(string);
            } else if (clazz == Double.TYPE || clazz == Double.class) {
                list = jSONObject.getDouble(string);
            } else if (clazz == Float.TYPE || clazz == Float.class) {
                list = Float.valueOf((float)jSONObject.getDouble(string));
            } else if (clazz == Long.TYPE || clazz == Long.class) {
                list = jSONObject.getLong(string);
            } else if (clazz == List.class) {
                list = JsonReflector.a(jSONObject.getJSONArray(string), clazz);
            } else {
                list = clazz.newInstance();
                JsonReflector.a(jSONObject.getJSONObject(string), list);
            }
            hashMap.put(string, (String)((Object)list));
        }
        return hashMap;
    }

    private static Object a(Class<?> clazz, JSONArray jSONArray, int n) throws IllegalAccessException, InstantiationException, JSONException, InvalidMappingException {
        Object object;
        if (jSONArray.isNull(n)) {
            object = null;
        } else if (clazz == List.class) {
            object = JsonReflector.a(jSONArray.getJSONArray(n), clazz);
        } else if (clazz == Set.class) {
            object = JsonReflector.b(jSONArray.getJSONArray(n), clazz);
        } else if (clazz == String.class) {
            object = jSONArray.getString(n);
        } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            object = jSONArray.getBoolean(n);
        } else if (clazz == Integer.TYPE || clazz == Integer.class) {
            object = jSONArray.getInt(n);
        } else if (clazz == Double.TYPE || clazz == Double.class) {
            object = jSONArray.getDouble(n);
        } else if (clazz == Float.TYPE || clazz == Float.class) {
            object = Float.valueOf((float)jSONArray.getDouble(n));
        } else if (clazz == Long.TYPE || clazz == Long.class) {
            object = jSONArray.getLong(n);
        } else {
            object = clazz.newInstance();
            if (!(object instanceof Jsonable)) {
                throw new IllegalArgumentException("The field type " + object + " must be Jsonable");
            }
            JSONObject jSONObject = jSONArray.getJSONObject(n);
            ((Jsonable)object).parseFromJSON(jSONObject);
            JsonReflector.a(jSONArray.getJSONObject(n), object);
        }
        return object;
    }

    private static boolean a(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == String.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Integer.class || clazz == Boolean.class;
    }

    public static <T> Collection<T> parseCollectionFromJSON(JSONObject json, Class<T> childrenType, String collectionKey, Collection<T> models) throws InvalidMappingException {
        try {
            JSONArray jSONArray = json.getJSONArray(collectionKey);
            for (int i = 0; i < jSONArray.length(); ++i) {
                T t = childrenType.newInstance();
                if (t instanceof Jsonable) {
                    ((Jsonable)t).parseFromJSON(jSONArray.getJSONObject(i));
                } else {
                    JsonReflector.a(jSONArray.getJSONObject(i), t);
                }
                models.add(t);
            }
        }
        catch (IllegalAccessException | InstantiationException | JSONException throwable) {
            // empty catch block
        }
        if (models != null) {
            // empty if block
        }
        return models;
    }

    public static JSONObject parseCollectionToJSON(Collection<?> models, String collectionKey) throws InvalidMappingException {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            for (Object obj : models) {
                if (obj instanceof Jsonable) {
                    jSONArray.put((Object)((Jsonable)obj).parseToJSON());
                    continue;
                }
                if (JsonReflector.a(obj.getClass())) {
                    jSONArray.put(obj);
                    continue;
                }
                jSONArray.put((Object)JsonReflector.a(obj));
            }
            jSONObject.put(collectionKey, (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            throw new InvalidMappingException(JsonableModel.class.getSimpleName() + " " + jSONException.getMessage(), (Exception)((Object)jSONException));
        }
        if (!jSONObject.has(collectionKey)) {
            throw new InvalidMappingException(JsonableModel.class.getSimpleName() + " json mapping has failed");
        }
        return jSONObject;
    }

    public static <T> Collection<T> parseCollectionFromJSONArray(JSONArray jsonArray, Class<T> childrenType, Collection<T> models) throws InvalidMappingException {
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                T t = childrenType.newInstance();
                if (t instanceof Jsonable) {
                    ((Jsonable)t).parseFromJSON(jsonArray.getJSONObject(i));
                } else {
                    JsonReflector.a(jsonArray.getJSONObject(i), t);
                }
                models.add(t);
            }
        }
        catch (IllegalAccessException | InstantiationException | JSONException throwable) {
            // empty catch block
        }
        if (models != null) {
            // empty if block
        }
        return models;
    }

    public static JSONArray parseCollectionToJSONArray(Collection<?> models) throws InvalidMappingException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : models) {
            if (obj instanceof Jsonable) {
                jSONArray.put((Object)((Jsonable)obj).parseToJSON());
                continue;
            }
            if (JsonReflector.a(obj.getClass())) {
                jSONArray.put(obj);
                continue;
            }
            jSONArray.put((Object)JsonReflector.a(obj));
        }
        return jSONArray;
    }

    private static Object b(Class<?> clazz) throws InstantiationException, IllegalArgumentException, InvocationTargetException, IllegalAccessException {
        Object var1_1 = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            var1_1 = constructor.newInstance(new Object[0]);
        }
        if (var1_1 == null) {
            throw new IllegalAccessException("Missing empty constructor for class " + clazz);
        }
        return var1_1;
    }

    public static HashMap<String, String> parseStringHashFromJSON(JSONObject json) throws JSONException {
        if (json == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = json.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            hashMap.put(string, json.getString(string));
        }
        return hashMap;
    }

    public static JSONObject parseStringHashToJSON(HashMap<String, String> hash) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry<String, String> entry : hash.entrySet()) {
            jSONObject.put(entry.getKey(), (Object)entry.getValue());
        }
        return jSONObject;
    }
}

