/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.data.local.database;

import com.inlocomedia.android.core.util.Validator;

public class StorageOperation {
    public static final int INSERT = 1;
    public static final int TRIM = 2;
    public static final int DUMP = 3;
    public static final int CLEAN = 4;
    private int a;
    private String b;
    private int c;
    private long d;
    private long e;
    private long f;
    private long g;

    public StorageOperation() {
        this.c = -1;
        this.d = -1L;
        this.e = -1L;
        this.f = -1L;
        this.g = -1L;
    }

    public StorageOperation(Builder builder) {
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c;
        this.d = builder.d;
        this.e = builder.e;
        this.f = builder.g;
        this.g = builder.f;
    }

    public int getOperation() {
        return this.a;
    }

    public String getStorageName() {
        return this.b;
    }

    public int getStorageVersion() {
        return this.c;
    }

    public long getSizeBefore() {
        return this.d;
    }

    public long getSizeAfter() {
        return this.e;
    }

    public long getEntriesBefore() {
        return this.f;
    }

    public long getEntriesAfter() {
        return this.g;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageOperation storageOperation = (StorageOperation)o;
        if (this.b != null ? !this.b.equals(storageOperation.b) : storageOperation.b != null) {
            return false;
        }
        if (this.c != storageOperation.c) {
            return false;
        }
        if (this.d != storageOperation.d) {
            return false;
        }
        if (this.e != storageOperation.e) {
            return false;
        }
        if (this.f != storageOperation.f) {
            return false;
        }
        return this.g == storageOperation.g;
    }

    public int hashCode() {
        int n = this.b != null ? this.b.hashCode() : 0;
        n = 31 * n + this.a;
        n = 31 * n + this.c;
        n = 31 * n + (int)(this.d ^ this.d >>> 32);
        n = 31 * n + (int)(this.e ^ this.e >>> 32);
        n = 31 * n + (int)(this.f ^ this.f >>> 32);
        n = 31 * n + (int)(this.g ^ this.g >>> 32);
        return n;
    }

    public static class Builder {
        private int a;
        private String b;
        private int c;
        private long d;
        private long e;
        private long f;
        private long g;

        public Builder setOperation(int operation) {
            this.a = operation;
            return this;
        }

        public Builder setStorageName(String storageName) {
            this.b = storageName;
            return this;
        }

        public Builder setStorageVersion(int storageVersion) {
            this.c = storageVersion;
            return this;
        }

        public Builder setSizeBefore(long sizeBefore) {
            this.d = sizeBefore;
            return this;
        }

        public Builder setSizeAfter(long sizeAfter) {
            this.e = sizeAfter;
            return this;
        }

        public Builder setEntriesBefore(long entriesBefore) {
            this.g = entriesBefore;
            return this;
        }

        public Builder setEntriesAfter(long entriesAfter) {
            this.f = entriesAfter;
            return this;
        }

        public StorageOperation build() {
            Validator.notNull(this.b, "Context");
            Validator.isNotNegative(this.c, "Storage version");
            Validator.isNotNegative(this.d, "Size before");
            Validator.isNotNegative(this.e, "Size after");
            Validator.isNotNegative(this.g, "Entries before");
            Validator.isNotNegative(this.f, "Entries after");
            return new StorageOperation(this);
        }
    }
}

