/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.profile;

import android.content.Context;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import com.inlocomedia.android.core.communication.util.NetworkAccessTools;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.profile.Device;
import com.inlocomedia.android.core.profile.UserRequestParams;
import com.inlocomedia.android.core.util.ScreenHelper;
import com.inlocomedia.android.core.util.TimeUtils;
import com.inlocomedia.android.core.util.Validator;
import java.lang.reflect.Constructor;
import java.util.TimeZone;

public class UserRequestParamsFactory<T extends UserRequestParams> {
    private static final String a = Logger.makeTag(UserRequestParamsFactory.class);
    private Class<T> b;

    public UserRequestParamsFactory(Class<T> klass) {
        this.b = klass;
    }

    public T getUserRequestParams(Context context) {
        try {
            Constructor<T> constructor = this.b.getConstructor(new Class[0]);
            UserRequestParams userRequestParams = (UserRequestParams)constructor.newInstance(new Object[0]);
            this.a(userRequestParams, context);
            return (T)userRequestParams;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void a(T t, Context context) {
        this.a(t);
        this.b(t);
        this.c(t);
        this.b(t, context);
        this.d(t);
        this.e(t);
        this.c(t, context);
        this.d(t, context);
        this.e(t, context);
        this.f(t, context);
    }

    private void a(T t) {
        ((UserRequestParams)t).mTimezone = TimeZone.getDefault().getID();
    }

    private void b(T t) {
        ((UserRequestParams)t).mTimestamp = System.currentTimeMillis();
    }

    private void c(T t) {
        ((UserRequestParams)t).mHour = TimeUtils.getCurrentHour();
    }

    private void b(T t, Context context) {
        ((UserRequestParams)t).mPackageName = context.getPackageName();
    }

    private void d(T t) {
        ((UserRequestParams)t).mSdkVersionName = "3.1.0";
        ((UserRequestParams)t).mSdkCodeVersion = 30100;
    }

    private void e(T t) {
        ((UserRequestParams)t).mOsName = "android";
        ((UserRequestParams)t).mOsVersionCode = Device.ANDROID_VERSION_CODE;
    }

    private void c(T t, Context context) {
        ((UserRequestParams)t).mDeviceModel = Device.MODEL;
        ((UserRequestParams)t).mDeviceManufacturer = Device.MANUFACTURER;
        ((UserRequestParams)t).mDeviceDesignName = Device.INDUSTRIAL_DESIGN_NAME;
        ((UserRequestParams)t).mScreenDensityRatio = Float.valueOf(ScreenHelper.getDensity(context));
    }

    private void d(T t, Context context) {
        ((UserRequestParams)t).mGoogleAId = Device.getGoogleAdvertisingId(context);
        ((UserRequestParams)t).mAdIdentifier = Device.getAdOrDeviceId(context);
        ((UserRequestParams)t).mAdTrackingEnabled = Device.isAdTrackingEnabled(context);
        ((UserRequestParams)t).mInLocoMediaId = Device.getDeviceId(context);
    }

    private void e(T t, Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ((UserRequestParams)t).mSimCountryISO = Device.b(telephonyManager);
        ((UserRequestParams)t).mNetworkCountryISO = Device.c(telephonyManager);
        ((UserRequestParams)t).mSimOperator = Device.a(telephonyManager);
        ((UserRequestParams)t).mNetworkOperator = Device.getNetworkCarrierName(telephonyManager);
    }

    private void f(T t, Context context) {
        NetworkInfo networkInfo = NetworkAccessTools.getActiveNetworkInfo(context);
        if (networkInfo != null && networkInfo.isConnectedOrConnecting()) {
            ((UserRequestParams)t).mConnectionType = String.valueOf(networkInfo.getType());
            if (networkInfo.getType() == 0) {
                ((UserRequestParams)t).mMobileConnectionType = String.valueOf(networkInfo.getSubtype());
            }
        }
    }

    public static UserRequestParams newParams(Context context) {
        Validator.notMainThread("Get UserRequestParams");
        return new UserRequestParamsFactory<UserRequestParams>(UserRequestParams.class).getUserRequestParams(context);
    }

    public static <T extends UserRequestParams> T newParams(Context context, Class<T> klass) {
        Validator.notMainThread("Get UserRequestParams");
        return new UserRequestParamsFactory<T>(klass).getUserRequestParams(context);
    }
}

