/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.schedulers.job_scheduler;

import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import com.inlocomedia.android.core.CoreReceiver;
import com.inlocomedia.android.core.annotations.AccessedByTests;
import com.inlocomedia.android.core.annotations.VisibleForTesting;
import com.inlocomedia.android.core.data.local.SharedPreferencesManager;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.schedulers.alarm.AlarmHelper;
import com.inlocomedia.android.core.schedulers.alarm.AlarmInfo;
import com.inlocomedia.android.core.schedulers.job_scheduler.Job;
import com.inlocomedia.android.core.schedulers.job_scheduler.a;
import com.inlocomedia.android.core.util.TimeUtils;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class JobScheduler {
    private static final String b = Logger.makeTag(JobScheduler.class);
    @VisibleForTesting
    static final long a = TimeUnit.MINUTES.toMillis(10L);
    private static JobScheduler c;
    private Context d;
    @AccessedByTests
    private Map<String, Job> e;
    @AccessedByTests
    private a f;

    @VisibleForTesting
    protected JobScheduler(Context context) {
        this.d = context.getApplicationContext();
        this.f = new a();
        this.a(this.e());
        this.g();
    }

    public static synchronized JobScheduler getInstance(Context context) {
        if (c == null) {
            c = new JobScheduler(context);
        }
        return c;
    }

    public static void onReceive(Context context, Intent intent) {
        JobScheduler.getInstance(context).onReceive(intent);
    }

    @VisibleForTesting
    public void onReceive(Intent intent) {
        Job job;
        String string;
        if (intent != null && this.e.containsKey(string = intent.getAction()) && (job = this.e.get(string)) != null) {
            if (this.f.a(this.d, job)) {
                this.c();
                Class<?> clazz = job.g();
                if (this.a(clazz, job)) {
                    if (job.h()) {
                        job.mNextAlarm = TimeUtils.convertElapsedIntervalToDate(SystemClock.elapsedRealtime() + job.getInterval());
                    }
                    this.a(job, 2);
                } else {
                    this.a(job.getId());
                }
            } else {
                this.b(job);
            }
        }
    }

    private void a(int n) {
        Job job;
        String string = Job.a(n);
        if (this.e.containsKey(string) && (job = this.e.get(string)) != null) {
            if (job.h()) {
                job.mNumTries = 0;
                this.a(job, 1);
            } else {
                this.b(job.getId());
            }
        }
        if (this.h()) {
            this.c();
        } else {
            this.b();
        }
    }

    public static void cancel(Context context, int jobId) {
        JobScheduler.getInstance(context).b(jobId);
    }

    private void b(int n) {
        Job job;
        String string = Job.a(n);
        if (this.e.containsKey(string) && (job = this.e.get(string)) != null) {
            AlarmHelper.disableAlarm(this.d, n);
            job.clear(this.d);
            this.e.remove(string);
            this.d();
        }
    }

    static void a(Context context) {
        JobScheduler.getInstance(context).a();
    }

    private void a() {
        for (String string : this.e.keySet()) {
            Job job = this.e.get(string);
            if (job == null) continue;
            AlarmHelper.disableAlarm(this.d, job.getId());
            job.clear(this.d);
        }
        this.b();
        this.e.clear();
        this.f();
    }

    public static void onReceiveRecovery(Context context) {
        JobScheduler.getInstance(context).onReceiveRecovery();
    }

    @VisibleForTesting
    public void onReceiveRecovery() {
        this.g();
    }

    private void b() {
        AlarmHelper.disableAlarm(this.d, 1);
    }

    private boolean a(Class<?> clazz, Job job) {
        try {
            Method method = clazz.getDeclaredMethod("onStartJob", Job.class);
            method.setAccessible(true);
            return (Boolean)method.invoke(null, job);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void a(Job job, int n) {
        job.mStatus = n;
        job.save(this.d);
    }

    private void b(Job job) {
        if (!this.a(job)) {
            this.b(job.getId());
        }
    }

    @VisibleForTesting
    boolean a(Job job) {
        ++job.mNumTries;
        long l = job.a() == 0 ? this.d(job) : this.c(job);
        if (job.b() > 0L && l > job.b()) {
            l = job.b();
        }
        if (this.a(job, l)) {
            job.mNextAlarm = TimeUtils.convertElapsedIntervalToDate(SystemClock.elapsedRealtime() + l);
            this.a(job, 1);
            return true;
        }
        return false;
    }

    private boolean a(Job job, long l) {
        AlarmInfo.Builder builder = new AlarmInfo.Builder().setAction("com.inlocomedia.android.9YYWSTGWKXE6QF8UUAYJ").setDescription(job.getDescription()).setReceiver(CoreReceiver.class).setLatency(l);
        if (job.h()) {
            builder.setInterval(job.getInterval());
        }
        return AlarmHelper.enableAlarm(this.d, job.getId(), builder.build());
    }

    private void c() {
        AlarmInfo alarmInfo = new AlarmInfo.Builder().setAction("com.inlocomedia.android.O4B3O4NJHA6745W3VSFO").setReceiver(CoreReceiver.class).setDescription("Recovery Alarm").setLatency(a).setInterval(a).build();
        AlarmHelper.enableAlarm(this.d, 1, alarmInfo);
    }

    private long c(Job job) {
        long l = 0L;
        if (job.mNumTries >= 1) {
            l = (long)((double)job.c() * Math.pow(2.0, job.mNumTries - 1));
        }
        return l;
    }

    private long d(Job job) {
        long l = 0L;
        if (job.mNumTries >= 1) {
            l = job.c() * (long)job.mNumTries;
        }
        return l;
    }

    private static SharedPreferencesManager.Entry b(Context context) {
        return SharedPreferencesManager.getInstance(context).getEntry("com.inlocomedia.android.core.schedulers.job_scheduler.JobScheduler");
    }

    private void d() {
        JobScheduler.b(this.d).put("key_set", this.e.keySet()).commit();
    }

    private Set<String> e() {
        return JobScheduler.b(this.d).getStringSet("key_set", new HashSet<String>());
    }

    private void f() {
        JobScheduler.b(this.d).clear();
    }

    private void a(Set<String> set) {
        this.e = new ConcurrentHashMap<String, Job>();
        for (String string : set) {
            Job job = new Job(this.d, Job.a(string));
            this.e.put(string, job);
        }
    }

    private void g() {
        for (String string : this.e.keySet()) {
            Job job = this.e.get(string);
            if (job == null) continue;
            if (job.mStatus == 0) {
                this.b(job);
                continue;
            }
            if (job.mNextAlarm >= System.currentTimeMillis()) continue;
            this.b(job);
        }
    }

    private boolean h() {
        for (String string : this.e.keySet()) {
            Job job = this.e.get(string);
            if (job == null || job.mStatus != 2) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public static void reset(Context context) {
        if (c != null) {
            JobScheduler.a(context);
            JobScheduler.c.e = null;
        }
        AlarmHelper.reset();
        c = null;
    }
}

