/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.requests;

import android.util.Log;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.communication.cache.CacheManager;
import com.inlocomedia.android.core.communication.requests.HttpRequest;
import com.inlocomedia.android.core.communication.requests.params.HttpRequestParams;
import com.inlocomedia.android.core.communication.responses.HttpUrlConnectionResponse;
import com.inlocomedia.android.core.communication.responses.UrlResponse;
import com.inlocomedia.android.core.communication.util.CacheConfig;
import com.inlocomedia.android.core.communication.util.LoadState;
import com.inlocomedia.android.core.communication.util.NetworkAccessTools;
import com.inlocomedia.android.core.exception.ErrorHandlerManager;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.OperationTimer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.Map;

public class HttpUrlConnectionRequest
extends HttpRequest {
    private static final String b = Logger.makeTag(HttpUrlConnectionRequest.class.getSimpleName());
    private HttpURLConnection c;

    public HttpUrlConnectionRequest(HttpRequestParams params, ErrorHandlerManager errorHandler) {
        super(params, errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UrlResponse run() {
        Object object;
        HttpUrlConnectionResponse httpUrlConnectionResponse = null;
        try {
            if (this.isCanceled()) {
                UrlResponse urlResponse = null;
                return urlResponse;
            }
            this.mParams.buildUrl();
            if (this.mParams.isCacheEnabled()) {
                httpUrlConnectionResponse = this.a();
            }
            if (httpUrlConnectionResponse == null) {
                String string = this.mParams.getUrl();
                NetworkAccessTools.validateNetworkAvailable(this.mParams.getContext());
                object = this.mParams.getMethod();
                this.c = (HttpURLConnection)new URL(string).openConnection();
                this.c.setReadTimeout(15000);
                this.c.setConnectTimeout(15000);
                this.c.setInstanceFollowRedirects(true);
                this.c.setRequestMethod((String)object);
                for (Map.Entry<String, String> object22 : this.mParams.getHeaders().entrySet()) {
                    this.c.setRequestProperty(object22.getKey(), object22.getValue());
                }
                this.c.setDoInput(true);
                if (this.mParams.getBody() != null) {
                    this.c.setDoOutput(true);
                    this.c.getOutputStream().write(this.mParams.getBody());
                }
                if (Environment.isCommunicationDebug()) {
                    this.print();
                }
                OperationTimer operationTimer = new OperationTimer();
                if (this.isCanceled()) {
                    UrlResponse urlResponse = null;
                    return urlResponse;
                }
                this.c.connect();
                if (this.isCanceled()) {
                    UrlResponse urlResponse = null;
                    return urlResponse;
                }
                httpUrlConnectionResponse = this.a(this.c);
                if (this.isCanceled()) {
                    UrlResponse urlResponse = null;
                    return urlResponse;
                }
                httpUrlConnectionResponse.setRequestedUrl(string);
                if (!httpUrlConnectionResponse.isSuccessful()) {
                    InLocoMediaException inLocoMediaException = this.handleError(string, httpUrlConnectionResponse);
                    httpUrlConnectionResponse.setErrorReceived(inLocoMediaException);
                } else {
                    if (this.mParams.isResponseCacheable()) {
                        this.a(this.c, httpUrlConnectionResponse.getData());
                    }
                    this.a(httpUrlConnectionResponse);
                }
                if (Environment.isCommunicationDebug()) {
                    Log.d((String)b, (String)("Request at " + this.mParams.getUrl() + " finished in " + operationTimer.getDuration() + " milliseconds."));
                    httpUrlConnectionResponse.print();
                }
            }
        }
        catch (Throwable throwable) {
            object = this.handleError(this.mParams.getUrl(), throwable);
            httpUrlConnectionResponse = new HttpUrlConnectionResponse((InLocoMediaException)object);
        }
        finally {
            this.shutdown();
        }
        if (this.isCanceled()) {
            return null;
        }
        this.a = LoadState.FINISHED;
        return httpUrlConnectionResponse;
    }

    private HttpUrlConnectionResponse a(HttpURLConnection httpURLConnection) throws IOException {
        Object object;
        HttpUrlConnectionResponse httpUrlConnectionResponse = new HttpUrlConnectionResponse((byte[])null);
        httpUrlConnectionResponse.setHeaders(this.c.getHeaderFields());
        String string = this.c.getContentType();
        if (string != null) {
            object = string.split(";")[0].trim();
            httpUrlConnectionResponse.setContentType((String)object);
        }
        try {
            httpUrlConnectionResponse.setStatusCode(httpURLConnection.getResponseCode());
            httpUrlConnectionResponse.setStatusMessage(httpURLConnection.getResponseMessage());
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null && iOException.getMessage().contains("No authentication challenges")) {
                httpUrlConnectionResponse.setStatusCode(401);
                httpUrlConnectionResponse.setStatusMessage("Unauthorized");
            }
            throw iOException;
        }
        object = this.a(httpUrlConnectionResponse.isSuccessful() ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream());
        httpUrlConnectionResponse.setData((byte[])object);
        return httpUrlConnectionResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] a(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                int n;
                byte[] byArray = new byte[4096];
                while (!this.isCanceled() && -1 != (n = inputStream.read(byArray))) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return byArray2;
            }
            finally {
                inputStream.close();
            }
        }
        return null;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.c != null) {
            this.c.disconnect();
        }
    }

    private HttpUrlConnectionResponse a() throws IOException {
        CacheConfig cacheConfig = this.mParams.getCacheConfig();
        CacheManager cacheManager = CacheManager.getInstance(this.mParams.getContext());
        if (cacheManager.isCached(cacheConfig.getKey())) {
            byte[] byArray = cacheManager.get(cacheConfig.getKey());
            if (Environment.isCommunicationDebug()) {
                Log.d((String)b, (String)("Request at " + this.mParams.getUrl() + " finished with cached value"));
            }
            return new HttpUrlConnectionResponse(byArray);
        }
        return null;
    }

    private void a(HttpURLConnection httpURLConnection, byte[] byArray) {
        Object object;
        String string = httpURLConnection.getHeaderField("Cache-Control");
        if (string != null && (((String)(object = string.toLowerCase(Locale.US))).contains("no-cache") || ((String)object).contains("no-store"))) {
            return;
        }
        if (Environment.isCommunicationDebug()) {
            Log.d((String)b, (String)("Caching response for url " + this.mParams.getUrl()));
        }
        object = CacheManager.getInstance(this.mParams.getContext());
        ((CacheManager)object).put(this.mParams.getCacheConfig().getKey(), byArray);
    }
}

