/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.VisibleForTesting;
import com.inlocomedia.android.core.AppContext;
import com.inlocomedia.android.core.annotations.AccessedByTests;
import com.inlocomedia.android.core.communication.AuthRequestBuilder;
import com.inlocomedia.android.core.communication.AuthenticationToken;
import com.inlocomedia.android.core.communication.Communication;
import com.inlocomedia.android.core.communication.Request;
import com.inlocomedia.android.core.communication.builders.HttpRequestBuilder;
import com.inlocomedia.android.core.communication.builders.SimpleHttpRequestBuilder;
import com.inlocomedia.android.core.communication.exception.NetworkUnavailableException;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.communication.requests.params.HttpRequestParams;
import com.inlocomedia.android.core.communication.util.CacheConfig;
import com.inlocomedia.android.core.communication.util.HttpUtils;
import com.inlocomedia.android.core.communication.util.NetworkAccessTools;
import com.inlocomedia.android.core.exception.ErrorHandlerManager;
import com.inlocomedia.android.core.exception.InLocoMediaAPIException;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.Holder;
import com.inlocomedia.android.core.util.ImageHelper;
import com.inlocomedia.android.core.util.ImageRequest;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestApi {
    private static final ErrorHandlerManager a;
    private static final String b;
    @AccessedByTests
    private static RequestApi c;

    public static Request requestBitmap(Context context, String url, RequestListener<Bitmap> listener) {
        return RequestApi.getInstance(context).requestBitmap(url, listener, url, null, null);
    }

    public static Request requestBitmap(Context context, String url, RequestListener<Bitmap> listener, String cacheKey, AuthenticationToken token) {
        return RequestApi.getInstance(context).requestBitmap(url, listener, cacheKey, token, null);
    }

    public static Request requestBitmap(Context context, String url, RequestListener<Bitmap> listener, String cacheKey, ImageRequest imageRequest) {
        return RequestApi.getInstance(context).requestBitmap(url, listener, cacheKey, null, imageRequest);
    }

    public Request requestBitmap(final String url, RequestListener<Bitmap> listener, final String cacheKey, final AuthenticationToken token, final ImageRequest imageRequest) {
        SimpleHttpRequestBuilder<Bitmap> simpleHttpRequestBuilder = new SimpleHttpRequestBuilder<Bitmap>(a){

            @Override
            public HttpRequestParams build() throws Throwable {
                Validator.notNullNorEmpty(url, "url");
                if (token != null) {
                    Validator.tokenAccess(token);
                }
                HttpRequestParams httpRequestParams = new HttpRequestParams(AppContext.get(), url);
                httpRequestParams.setHeaders(HttpUtils.getHeaderGroupForAnything());
                httpRequestParams.setCacheConfig(new CacheConfig(cacheKey, CacheConfig.Type.DEFAULT));
                return httpRequestParams;
            }

            public Bitmap a(byte[] byArray) throws Throwable {
                if (byArray == null) {
                    throw new InLocoMediaAPIException("Null response for image request at url " + url);
                }
                Bitmap bitmap = imageRequest == null ? ImageHelper.decode(byArray, null, 0, 0) : ImageHelper.decode(byArray, imageRequest.getImageView(), imageRequest.getMaxWidth(), imageRequest.getMaxHeight());
                if (bitmap == null || bitmap.getByteCount() == 0) {
                    throw new InLocoMediaAPIException("The bitmap could not be decoded for url " + url);
                }
                return bitmap;
            }

            @Override
            public AuthRequestBuilder<?> getAuthenticationBuilder() {
                return token != null ? Communication.getBaseAuthenticationBuilder(AppContext.get(), token) : null;
            }

            @Override
            public /* synthetic */ Object convert(byte[] byArray) throws Throwable {
                return this.a(byArray);
            }
        };
        return Request.get(Communication.executeWithThreadLimit(simpleHttpRequestBuilder, listener));
    }

    public static Request requestHtml(Context context, String url, RequestListener<String> listener) {
        return RequestApi.getInstance(context).requestHtml(url, listener);
    }

    public Request requestHtml(final String url, RequestListener<String> listener) {
        SimpleHttpRequestBuilder<String> simpleHttpRequestBuilder = new SimpleHttpRequestBuilder<String>(a){

            @Override
            public HttpRequestParams build() throws Throwable {
                Validator.notNullNorEmpty(url, "url");
                HttpRequestParams httpRequestParams = new HttpRequestParams(AppContext.get(), url);
                httpRequestParams.setHeaders(HttpUtils.getHeaderGroupForHtml(AppContext.get()));
                httpRequestParams.setCacheConfig(new CacheConfig(url, CacheConfig.Type.DEFAULT));
                return httpRequestParams;
            }

            public String a(byte[] byArray) throws Throwable {
                return new String(byArray, "UTF-8");
            }

            @Override
            public /* synthetic */ Object convert(byte[] byArray) throws Throwable {
                return this.a(byArray);
            }
        };
        return Request.get(Communication.executeAsync(simpleHttpRequestBuilder, listener));
    }

    public static Request registerUrl(Context context, String url, RequestListener<Void> listener) {
        return RequestApi.getInstance(context).registerUrl(url, listener);
    }

    public Request registerUrl(final String url, RequestListener<Void> listener) {
        SimpleHttpRequestBuilder<Void> simpleHttpRequestBuilder = new SimpleHttpRequestBuilder<Void>(a){

            @Override
            public HttpRequestParams build() throws Throwable {
                Validator.notNull(url, "Register url");
                return new HttpRequestParams(AppContext.get(), url);
            }

            public Void a(byte[] byArray) throws Throwable {
                return null;
            }

            @Override
            public /* synthetic */ Object convert(byte[] byArray) throws Throwable {
                return this.a(byArray);
            }
        };
        return Request.get(Communication.executeAsync(simpleHttpRequestBuilder, listener));
    }

    public static List<Request> registerUrls(Context context, Collection<String> urls, RequestListener<Void> listener) {
        return RequestApi.getInstance(context).a(urls, listener);
    }

    private List<Request> a(Collection<String> collection, final RequestListener<Void> requestListener) {
        final AtomicInteger atomicInteger = new AtomicInteger(collection.size());
        final Holder holder = new Holder();
        ArrayList<Request> arrayList = new ArrayList<Request>();
        if (!NetworkAccessTools.isNetworkAvailable(AppContext.get())) {
            ThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    requestListener.onRequestFailed(new NetworkUnavailableException());
                }
            });
            return new ArrayList<Request>();
        }
        for (final String string : collection) {
            HttpRequestBuilder<Void> httpRequestBuilder = new HttpRequestBuilder<Void>(a){

                @Override
                public HttpRequestParams build() throws Throwable {
                    Validator.notNull(string, "Register url");
                    return new HttpRequestParams(AppContext.get(), string);
                }

                public Void a(byte[] byArray) throws Throwable {
                    return null;
                }

                @Override
                public /* synthetic */ Object convert(byte[] byArray) throws Throwable {
                    return this.a(byArray);
                }
            };
            arrayList.add(Request.get(Communication.executeAsync(httpRequestBuilder, new RequestListener<Void>(){

                public void a(Void void_) {
                    int n;
                    if (requestListener != null && (n = atomicInteger.decrementAndGet()) == 0) {
                        InLocoMediaException inLocoMediaException = (InLocoMediaException)holder.get();
                        if (inLocoMediaException == null) {
                            requestListener.onRequestFinished(null);
                        } else {
                            requestListener.onRequestFailed(inLocoMediaException);
                        }
                    }
                }

                @Override
                public void onRequestFailed(InLocoMediaException error) {
                    if (requestListener != null) {
                        holder.set(error);
                        int n = atomicInteger.decrementAndGet();
                        if (n == 0) {
                            requestListener.onRequestFailed(error);
                        }
                    }
                }

                @Override
                public /* synthetic */ void onRequestFinished(Object object) {
                    this.a((Void)object);
                }
            })));
        }
        return arrayList;
    }

    public static synchronized RequestApi getInstance(Context context) {
        if (c == null) {
            c = new RequestApi(context);
        }
        return c;
    }

    public RequestApi(Context context) {
        AppContext.set(context);
    }

    @VisibleForTesting
    public static void reset() {
        c = null;
    }

    static {
        b = Logger.makeTag(RequestApi.class);
        a = new ErrorHandlerManager();
    }
}

