/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.content.Context;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailability;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.util.DependencyHelper;
import com.inlocomedia.android.core.util.Validator;

public final class GooglePlayServicesHelper {
    private static Boolean a;

    public static synchronized boolean isGooglePlayServicesAvailable(Context context) {
        if (a == null) {
            Integer n = null;
            try {
                a = false;
                Validator.notMainThread("GooglePlayServices isAvailable");
                if (DependencyHelper.isClassAvailable("com.google.android.gms.common.GoogleApiAvailability")) {
                    n = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
                    a = 0 == n;
                }
            }
            catch (Exception exception) {
                a = false;
            }
            finally {
                if (!a.booleanValue()) {
                    if (n != null) {
                        String string = GooglePlayServicesHelper.a(n);
                        DevLogger.w("GooglePlayServices access error. GooglePlayServices isAvailable returned error code: " + n + " (" + string + ")");
                    } else {
                        DevLogger.w("GooglePlayServices access error. Did you add the 'com.google.android.gms:play-services' dependency?");
                    }
                }
            }
        }
        return a;
    }

    public static int getGooglePlayServicesVersion(Context context) {
        if (GooglePlayServicesHelper.isGooglePlayServicesAvailable(context)) {
            return GoogleApiAvailability.GOOGLE_PLAY_SERVICES_VERSION_CODE;
        }
        return -1;
    }

    public static boolean isAdvertisingIdClientClassAvailable(Context context) {
        return GooglePlayServicesHelper.isGooglePlayServicesAvailable(context) && DependencyHelper.isClassAvailable("com.google.android.gms.ads.identifier.AdvertisingIdClient");
    }

    public static synchronized String getAdvertisingId(Context context) {
        String string = null;
        if (GooglePlayServicesHelper.isAdvertisingIdClientClassAvailable(context)) {
            try {
                AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                if (info != null) {
                    string = info.getId();
                }
            }
            catch (Exception exception) {
                DevLogger.w("GooglePlayServices access error: Unable to obtain AdvertisingIdClient.getAdvertisingIdInfo()");
            }
        }
        return string;
    }

    public static synchronized boolean isLimitAdTrackingEnabled(Context context) {
        boolean bl = false;
        if (GooglePlayServicesHelper.isAdvertisingIdClientClassAvailable(context)) {
            try {
                AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                if (info != null) {
                    bl = info.isLimitAdTrackingEnabled();
                }
            }
            catch (Exception exception) {
                DevLogger.w("GooglePlayServices access error: Unable to obtain AdvertisingIdClient.getAdvertisingIdInfo()");
            }
        }
        return bl;
    }

    public static boolean isGeofenceClassAvailable(Context context) {
        return GooglePlayServicesHelper.isGooglePlayServicesAvailable(context) && DependencyHelper.isClassAvailable("com.google.android.gms.location.Geofence");
    }

    private static String a(int n) {
        switch (n) {
            case 1: {
                return "Service Missing";
            }
            case 2: {
                return "Service Version Update Required";
            }
            case 3: {
                return "Service Disabled";
            }
            case 4: {
                return "Sign in Required";
            }
            case 5: {
                return "Invalid Account";
            }
            case 6: {
                return "Resolution Required";
            }
            case 7: {
                return "Network Error";
            }
            case 8: {
                return "Internal Error";
            }
            case 9: {
                return "Service Invalid";
            }
            case 10: {
                return "Developer error";
            }
            case 11: {
                return "License check failed";
            }
            case 13: {
                return "Canceled";
            }
            case 14: {
                return "Timeout";
            }
            case 15: {
                return "Interrupted";
            }
            case 16: {
                return "API Unavailable";
            }
            case 17: {
                return "Sign in Failed";
            }
            case 18: {
                return "Service Updating";
            }
        }
        return "Unknown Code";
    }
}

