/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.inlocomedia.android.core.communication.exception.NetworkUnavailableException;
import com.inlocomedia.android.core.util.Validator;

public final class NetworkAccessTools {
    private NetworkAccessTools() {
    }

    public static boolean isNetworkAvailable(Context context) {
        Validator.notNull(context, "Context");
        NetworkInfo networkInfo = NetworkAccessTools.getActiveNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnectedOrConnecting();
    }

    public static boolean isConnectedViaWifi(Context context) {
        Validator.notNull(context, "Context");
        NetworkInfo networkInfo = NetworkAccessTools.getActiveNetworkInfo(context);
        return networkInfo != null && networkInfo.getType() == 1 && networkInfo.isConnectedOrConnecting();
    }

    public static NetworkInfo getActiveNetworkInfo(Context context) {
        Validator.notNull(context, "Context");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivityManager.getActiveNetworkInfo();
    }

    public static void validateNetworkAvailable(Context context) throws NetworkUnavailableException {
        Validator.notNull(context, "Context");
        if (!NetworkAccessTools.isNetworkAvailable(context)) {
            throw new NetworkUnavailableException();
        }
    }
}

