/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Looper;
import android.webkit.URLUtil;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.communication.AuthenticationId;
import com.inlocomedia.android.core.communication.AuthenticationToken;
import com.inlocomedia.android.core.communication.exception.UnauthorizedException;
import com.inlocomedia.android.core.exception.InvalidAndroidSDKVersion;
import com.inlocomedia.android.core.log.DevLogger;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class Validator {
    public static final int MINIMUM_SUPPORTED_VERSION = 14;
    private static final String[] a = new String[]{"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"};

    private Validator() {
    }

    public static void tokenAccess(AuthenticationToken token) throws UnauthorizedException, InvalidAndroidSDKVersion {
        Validator.sdkVersion();
        if (!Validator.token(token)) {
            throw new UnauthorizedException("You must register your application with an id before using this service");
        }
    }

    public static void authenticationIdAccess(AuthenticationId clientId) throws UnauthorizedException, InvalidAndroidSDKVersion {
        Validator.sdkVersion();
        if (!Validator.clientId(clientId)) {
            throw new UnauthorizedException("You must register your application with an id before using this service");
        }
    }

    public static boolean token(AuthenticationToken token) {
        return token != null && !Validator.isNullOrEmpty(token.getClientId()) && !Validator.isNullOrEmpty(token.getSecret());
    }

    public static boolean clientId(AuthenticationId authenticationId) {
        return authenticationId != null && !Validator.isNullOrEmpty(authenticationId.getClientId());
    }

    public static void sdkVersion() throws InvalidAndroidSDKVersion {
        if (!Validator.isValidSDKVersion()) {
            String string = String.format(Locale.US, "This device SDK version is below the minimum required version. Minimum: %s, Current %s", 14, Build.VERSION.SDK_INT);
            throw new InvalidAndroidSDKVersion(string);
        }
    }

    public static boolean isValidSDKVersion() {
        return Build.VERSION.SDK_INT >= 14;
    }

    public static void manifest(Context context) {
        Validator.permissions(context);
    }

    static boolean a(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            if (packageInfo.requestedPermissions != null) {
                for (String string : packageInfo.requestedPermissions) {
                    if (!string.equals("android.permission.WRITE_EXTERNAL_STORAGE")) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void permissions(Context context) {
        for (String string : a) {
            if (Validator.isPermissionEnabled(context, string)) continue;
            Environment.CoreModulesManager.SDK.setInvalid();
            DevLogger.e("Missing required permission: " + string + ". It's required to include the permission in your AndroidManifest file");
        }
    }

    static boolean b(Context context) {
        int n = context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE");
        return n == 0;
    }

    public static void libraryDependencies() {
        try {
            Class.forName("android.support.v4.util.LruCache");
        }
        catch (ClassNotFoundException classNotFoundException) {
            DevLogger.e("Configuration error: Missing required library 'Android Support v4'");
            Environment.CoreModulesManager.SDK.setInvalid();
        }
    }

    public static boolean isPermissionEnabled(Context context, String permission2) {
        int n = context.checkCallingOrSelfPermission(permission2);
        return n == 0;
    }

    public static boolean isPermissionGrantable(Context context, String permission2) {
        return !Validator.isBelowAndroid23() || Validator.isPermissionEnabled(context, permission2);
    }

    public static void notNull(Object arg, String name) {
        if (arg == null) {
            throw new NullPointerException("Argument '" + name + "' cannot be null");
        }
    }

    public static void isValidUrl(String url, String name) {
        if (!Validator.isValidUrl(url)) {
            throw new IllegalArgumentException("Url argument '" + name + "' is invalid");
        }
    }

    public static boolean isValidHttpUrl(String url) {
        return URLUtil.isHttpUrl((String)url) || URLUtil.isHttpsUrl((String)url);
    }

    public static boolean isValidUrl(String url) {
        return URLUtil.isValidUrl((String)url);
    }

    public static void notNullNorEmpty(String arg, String name) {
        if (Validator.isNullOrEmpty(arg)) {
            throw new IllegalArgumentException("Argument '" + name + "' cannot be null or empty");
        }
    }

    public static boolean isNullOrEmpty(Collection<?> c2) {
        return c2 == null || c2.size() == 0;
    }

    public static boolean isNullOrEmpty(Map<?, ?> c2) {
        return c2 == null || c2.size() == 0;
    }

    public static boolean areNotNullNorEmpty(String ... strings) {
        if (strings == null || strings.length == 0) {
            return false;
        }
        for (String string : strings) {
            if (!Validator.isNullOrEmpty(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isMainThread() throws RuntimeException {
        return Looper.getMainLooper().equals(Looper.myLooper());
    }

    public static void mainThread(String tag) throws RuntimeException {
        if (!Validator.isMainThread()) {
            throw new RuntimeException("[" + tag + "] You need to be on the UI Thread to perform this operation");
        }
    }

    public static void notMainThread(String tag) throws RuntimeException {
        if (Validator.isMainThread()) {
            throw new RuntimeException("[" + tag + "] You can't execute this operation on the UI Thread");
        }
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public static boolean isAboveOrEqualsToAndroid18() {
        return Build.VERSION.SDK_INT >= 18;
    }

    public static boolean isBelowAndroid23() {
        return Build.VERSION.SDK_INT < 23;
    }

    public static boolean isAboveOrEqualsAndroid16() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static boolean isAboveOrEqualsAndroid17() {
        return Build.VERSION.SDK_INT >= 17;
    }

    public static boolean isReceiverRegistered(Context context, Class<?> receiverKlass, String action) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent(context, receiverKlass);
        if (action != null) {
            intent.setAction(action);
        }
        List list = packageManager.queryBroadcastReceivers(intent, 32);
        for (ResolveInfo resolveInfo : list) {
            String string = resolveInfo.activityInfo.name;
            try {
                Class<?> clazz = Class.forName(string);
                if (!clazz.equals(receiverKlass)) continue;
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        return false;
    }
}

