/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.ViewPropertyAnimator;
import android.widget.ImageView;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.R;
import com.inlocomedia.android.core.RequestApi;
import com.inlocomedia.android.core.communication.Request;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.exception.InLocoMediaUnhandledException;
import com.inlocomedia.android.core.log.CriticalErrorManager;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.ImageRequest;
import com.inlocomedia.android.core.util.MemoryCache;
import com.inlocomedia.android.core.util.ThreadPool;

@TargetApi(value=14)
public final class ImageViewDownloadManager {
    private static final String a = Logger.makeTag(ImageViewDownloadManager.class);
    private static final int b = R.id.ilm_private_id_url;
    private static final int c = R.id.ilm_private_id_recycled;
    private static final int d = R.id.ilm_private_id_placeholder;
    private static final int e = R.id.ilm_private_id_request;
    private static final int f = R.id.ilm_private_id_request_listener;
    private static final int g = R.id.ilm_private_id_user_listener;

    public static ImageRequest with(Context context) {
        return new ImageRequest(context);
    }

    public static void setMaxMemoryCacheSize(int maxMemorySize) {
        MemoryCache.a(maxMemorySize);
    }

    public static void clearMemoryCache() {
        MemoryCache.clear();
    }

    static boolean a(final @NonNull ImageRequest imageRequest) {
        try {
            final ImageView imageView = imageRequest.getImageView();
            String string = imageRequest.getUrl();
            RequestListener<Void> requestListener = imageRequest.getListener();
            if (string.equals(imageView.getTag(b))) {
                return false;
            }
            ThreadPool.executeInMain(new Runnable(){

                @Override
                public void run() {
                    imageView.setImageDrawable(null);
                    imageView.measure(0, 0);
                    if (imageRequest.c()) {
                        ImageViewDownloadManager.b(imageView, imageRequest.a());
                    }
                }
            });
            ImageViewDownloadManager.b(imageView);
            ImageViewDownloadManager.a(imageView, string);
            ImageViewDownloadManager.a(imageView, requestListener);
            ImageViewDownloadManager.c(imageView);
            Bitmap bitmap = null;
            if (imageRequest.e()) {
                bitmap = MemoryCache.getInstance(imageRequest.getContext()).get(string);
            }
            if (bitmap != null && bitmap.getWidth() >= imageView.getMeasuredWidth() && bitmap.getHeight() >= imageView.getMeasuredHeight()) {
                imageView.setImageBitmap(bitmap);
                return false;
            }
            a a2 = new a(imageRequest, string);
            imageView.setTag(f, (Object)a2);
            imageView.setTag(e, (Object)RequestApi.requestBitmap(imageRequest.getContext(), string, (RequestListener<Bitmap>)a2, string, imageRequest));
            return true;
        }
        catch (Throwable throwable) {
            CriticalErrorManager.notifyError(a, throwable, Environment.CoreModulesManager.SDK, true);
            return false;
        }
    }

    private static void b(@NonNull ImageView imageView) {
        try {
            a a2;
            final Request request = (Request)imageView.getTag(e);
            if (request != null) {
                ThreadPool.executeInBackground(new Runnable(){

                    @Override
                    public void run() {
                        request.cancel();
                    }
                });
            }
            if ((a2 = (a)imageView.getTag(f)) != null) {
                a2.a();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void a(@NonNull ImageView imageView, @NonNull RequestListener<Void> requestListener) {
        imageView.setTag(g, requestListener);
    }

    private static void a(@NonNull ImageView imageView, @NonNull String string) {
        imageView.setTag(b, (Object)string);
    }

    private static void c(@NonNull ImageView imageView) {
        try {
            boolean bl;
            boolean bl2 = bl = imageView.getTag(c) != null;
            if (!bl) {
                imageView.setTag(c, (Object)true);
                Drawable drawable = imageView.getDrawable();
                if (drawable != null) {
                    imageView.setTag(d, (Object)drawable.getConstantState());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void b(final @NonNull ImageView imageView, final Drawable drawable) {
        ThreadPool.executeInMain(new Runnable(){

            @Override
            public void run() {
                try {
                    imageView.setImageDrawable(drawable);
                    ImageViewDownloadManager.c(imageView, false);
                }
                catch (Throwable throwable) {
                    ImageViewDownloadManager.d(imageView, false);
                }
            }
        });
    }

    private static void c(final @NonNull ImageRequest imageRequest) {
        ThreadPool.executeInMain(new Runnable(){

            @Override
            public void run() {
                try {
                    ImageView imageView = imageRequest.getImageView();
                    if (imageRequest.d()) {
                        imageView.setImageDrawable(imageRequest.b());
                        ImageViewDownloadManager.c(imageView, false);
                    } else {
                        ImageViewDownloadManager.d(imageView, false);
                    }
                }
                catch (Throwable throwable) {
                    ImageViewDownloadManager.d(imageRequest.getImageView(), false);
                }
            }
        });
    }

    private static void c(@NonNull ImageView imageView, boolean bl) {
        if (bl) {
            ViewPropertyAnimator viewPropertyAnimator = imageView.animate();
            viewPropertyAnimator.cancel();
            imageView.setAlpha(0.0f);
            viewPropertyAnimator.alpha(1.0f).start();
        } else {
            imageView.setAlpha(1.0f);
        }
    }

    private static void d(ImageView imageView, boolean bl) {
        if (bl) {
            ViewPropertyAnimator viewPropertyAnimator = imageView.animate();
            viewPropertyAnimator.cancel();
            viewPropertyAnimator.alpha(0.0f).start();
        } else {
            imageView.setAlpha(0.0f);
        }
    }

    private static void b(final @NonNull ImageView imageView, final InLocoMediaException inLocoMediaException) {
        ThreadPool.executeInMain(new Runnable(){

            @Override
            public void run() {
                RequestListener requestListener = (RequestListener)imageView.getTag(g);
                if (requestListener != null) {
                    requestListener.onRequestFailed(inLocoMediaException);
                }
            }
        });
    }

    private static void d(final @NonNull ImageView imageView) {
        ThreadPool.executeInMain(new Runnable(){

            @Override
            public void run() {
                RequestListener requestListener = (RequestListener)imageView.getTag(g);
                if (requestListener != null) {
                    requestListener.onRequestFinished(null);
                }
            }
        });
    }

    private static class a
    implements RequestListener<Bitmap> {
        private final ImageRequest a;
        private final String b;
        private boolean c;

        a(ImageRequest imageRequest, String string) {
            this.a = imageRequest;
            this.b = string;
            this.c = false;
        }

        public void a(final Bitmap bitmap) {
            block5: {
                if (this.c) {
                    return;
                }
                try {
                    final ImageView imageView = this.a.getImageView();
                    if (imageView == null || imageView.getTag(b) == null || !imageView.getTag(b).equals(this.b)) {
                        return;
                    }
                    imageView.setTag(b, null);
                    if (this.a.e()) {
                        MemoryCache.getInstance(this.a.getContext()).put(this.b, bitmap);
                    }
                    ThreadPool.executeInMain(new Runnable(){

                        @Override
                        public void run() {
                            if (a.this.c) {
                                return;
                            }
                            try {
                                imageView.setImageBitmap(bitmap);
                            }
                            catch (Throwable throwable) {
                                Log.w((String)a, (String)("Cannot set bitmap. MainQueue.execute() has failed: " + InLocoMediaException.getFormattedMessage(throwable)));
                                ImageViewDownloadManager.c(a.this.a);
                            }
                            ImageViewDownloadManager.d(imageView);
                        }
                    });
                }
                catch (Throwable throwable) {
                    ImageView imageView = this.a.getImageView();
                    if (imageView == null) break block5;
                    ImageViewDownloadManager.c(this.a);
                    ImageViewDownloadManager.b(imageView, new InLocoMediaException("Unhandled error in ImageView loading", throwable));
                    CriticalErrorManager.notifyError(a, throwable, Environment.CoreModulesManager.SDK, true);
                }
            }
        }

        @Override
        public void onRequestFailed(InLocoMediaException error) {
            if (this.c) {
                return;
            }
            if (error instanceof InLocoMediaUnhandledException && this.a != null) {
                CriticalErrorManager.notifyError(a, error, Environment.CoreModulesManager.SDK, true);
            }
            if (this.a != null) {
                ImageViewDownloadManager.c(this.a);
                ImageViewDownloadManager.b(this.a.getImageView(), error);
            }
        }

        public void a() {
            this.c = true;
        }

        @Override
        public /* synthetic */ void onRequestFinished(Object object) {
            this.a((Bitmap)object);
        }
    }
}

