/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.builders;

import android.content.Context;
import com.inlocomedia.android.core.communication.AuthRequestBuilder;
import com.inlocomedia.android.core.communication.AuthenticationToken;
import com.inlocomedia.android.core.communication.DataConverter;
import com.inlocomedia.android.core.communication.requests.params.HttpRequestParams;
import com.inlocomedia.android.core.communication.requests.params.JsonRequestParams;
import com.inlocomedia.android.core.communication.util.HttpUtils;
import com.inlocomedia.android.core.communication.util.RestfulMethod;
import com.inlocomedia.android.core.util.Validator;
import org.json.JSONObject;

public class BaseAuthenticationRequestBuilder
extends AuthRequestBuilder<JSONObject> {
    private final Context a;
    private final AuthenticationToken b;

    public BaseAuthenticationRequestBuilder(Context context, AuthenticationToken token) {
        this.a = context.getApplicationContext();
        this.b = token;
    }

    @Override
    public JSONObject convert(byte[] array) throws Exception {
        return DataConverter.JSON.convert(array);
    }

    @Override
    public HttpRequestParams build() throws Throwable {
        Validator.notNull(this.b, "Authentication Token");
        JsonRequestParams jsonRequestParams = new JsonRequestParams(this.a, new RestfulMethod(1, this.b.getAuthenticationUrl()));
        jsonRequestParams.setHeaders(HttpUtils.getHeaderGroupForOauth(this.b.getClientId(), this.b.getSecret()));
        jsonRequestParams.setBody(HttpUtils.getOauthBody());
        return jsonRequestParams;
    }

    @Override
    public void onAuthCompleted(JSONObject response) {
        this.b.update(response);
    }

    @Override
    public AuthenticationToken getAuthenticationToken() {
        return this.b;
    }

    @Override
    public void addTokenToRequest(HttpRequestParams requestParams) {
        if (!Validator.isNullOrEmpty(this.b.getTokenKey())) {
            requestParams.addUrlParam(this.b.getTokenKey(), this.b.getToken());
        }
    }
}

