/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.config;

import android.content.Context;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.communication.util.RestfulMethod;
import com.inlocomedia.android.core.config.ConfigHandler;
import com.inlocomedia.android.core.config.ConfigurationModel;
import com.inlocomedia.android.core.config.CyclicReloader;
import com.inlocomedia.android.core.config.Reloader;
import com.inlocomedia.android.core.config.ReloaderListener;
import com.inlocomedia.android.core.data.remote.DataRequestor;
import com.inlocomedia.android.core.data.remote.SerializedData;
import com.inlocomedia.android.core.exception.ErrorHandlerManager;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.ThreadPool;

public class ConfigManager {
    private static final String a = Logger.makeTag(ConfigManager.class);
    private Reloader b;
    private DataRequestor c;

    public ConfigManager(Context context, ErrorHandlerManager errorHandlerManager) {
        this.c = new DataRequestor(context, errorHandlerManager);
    }

    public ConfigManager(DataRequestor requestor) {
        this.c = requestor;
    }

    public boolean start(final Context context, final RestfulMethod endpoint, final ConfigHandler configHandler, final RequestListener<ConfigurationModel> listener) {
        if (this.b != null) {
            return false;
        }
        this.b = new CyclicReloader(context, ConfigurationModel.DEFAULT_SELF_UPDATE_TIME, configHandler.getUniqueName(), new ReloaderListener(){

            @Override
            public void onTimeToReload() {
                ThreadPool.executeInBackground(new Runnable(){

                    @Override
                    public void run() {
                        SerializedData serializedData = configHandler.generateRequestData(context, listener);
                        ConfigManager.this.c.sendRequestWithData(serializedData, endpoint, new RequestListener<byte[]>(){

                            public void a(byte[] byArray) {
                                configHandler.processReceivedData(context, byArray, listener);
                            }

                            @Override
                            public void onRequestFailed(InLocoMediaException error) {
                                if (listener != null) {
                                    listener.onRequestFailed(error);
                                }
                            }

                            @Override
                            public /* synthetic */ void onRequestFinished(Object object) {
                                this.a((byte[])object);
                            }
                        });
                    }
                });
            }

            @Override
            public void onError(Throwable throwable) {
                configHandler.onError(throwable, listener);
            }
        });
        this.b.start();
        return true;
    }

    public void reset() {
        if (this.b != null) {
            this.b.finish();
            this.b = null;
        }
    }
}

