/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.requests;

import android.util.Log;
import com.inlocomedia.android.core.communication.cache.CacheManager;
import com.inlocomedia.android.core.communication.exception.NetworkException;
import com.inlocomedia.android.core.communication.exception.NetworkUnavailableException;
import com.inlocomedia.android.core.communication.exception.TimeoutException;
import com.inlocomedia.android.core.communication.exception.UnauthorizedException;
import com.inlocomedia.android.core.communication.requests.params.HttpRequestParams;
import com.inlocomedia.android.core.communication.responses.UrlResponse;
import com.inlocomedia.android.core.communication.util.HttpUtils;
import com.inlocomedia.android.core.communication.util.LoadState;
import com.inlocomedia.android.core.exception.ErrorHandlerManager;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.exception.InLocoMediaUnhandledException;
import com.inlocomedia.android.core.log.Logger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import org.apache.http.conn.ConnectTimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class HttpRequest {
    private static final String b = Logger.makeTag(HttpRequest.class.getSimpleName());
    protected final HttpRequestParams mParams;
    private final ErrorHandlerManager c;
    LoadState a;

    HttpRequest(HttpRequestParams params, ErrorHandlerManager errorHandler) {
        this.mParams = params;
        this.a = LoadState.INACTIVE;
        this.c = errorHandler;
    }

    public void removeCached() {
        if (this.mParams.getCacheConfig().isEnabled()) {
            CacheManager cacheManager = CacheManager.getInstance(this.mParams.getContext());
            cacheManager.clear(this.mParams.getCacheConfig().getKey());
        }
    }

    public void cancel() {
        this.a = LoadState.CANCELED;
    }

    public boolean isFinished() {
        return this.a == LoadState.FINISHED;
    }

    public boolean isRunning() {
        return this.a == LoadState.RUNNING;
    }

    public boolean isCanceled() {
        return this.a == LoadState.CANCELED;
    }

    public void shutdown() {
    }

    public HttpRequestParams getParams() {
        return this.mParams;
    }

    public LoadState getState() {
        return this.a;
    }

    protected InLocoMediaException handleError(String url, Throwable error) {
        return this.a(url, null, error);
    }

    protected InLocoMediaException handleError(String url, UrlResponse response) {
        return this.a(url, response, null);
    }

    private InLocoMediaException a(String string, UrlResponse urlResponse, Throwable throwable) {
        if (urlResponse != null) {
            if (urlResponse.isUnauthorized()) {
                return new UnauthorizedException("Unauthorized: " + urlResponse.getStatusCode());
            }
            if (this.c != null) {
                try {
                    InLocoMediaException inLocoMediaException;
                    JSONObject jSONObject = this.b(urlResponse);
                    if (jSONObject != null && (inLocoMediaException = this.c.responseHandler(jSONObject)) != null) {
                        return inLocoMediaException;
                    }
                }
                catch (IOException | JSONException throwable2) {
                    return new NetworkException((Exception)throwable2, string);
                }
            }
            return new NetworkException(urlResponse.getStatusMessage(), urlResponse.getStatusCode(), string);
        }
        if (throwable != null) {
            if (throwable instanceof ConnectTimeoutException || throwable instanceof SocketTimeoutException) {
                return new TimeoutException(InLocoMediaException.getFormattedMessage(throwable), string, throwable);
            }
            if (throwable instanceof NetworkUnavailableException) {
                return (InLocoMediaException)throwable;
            }
            if (throwable instanceof IOException) {
                return new NetworkException(InLocoMediaException.getFormattedMessage(throwable) + " at url " + string, throwable);
            }
            return new InLocoMediaUnhandledException(InLocoMediaException.getFormattedMessage(throwable), throwable);
        }
        return new NetworkException("An unexpected flow occurred. No HttpResponse nor error was received");
    }

    private JSONObject b(UrlResponse urlResponse) throws IOException, JSONException {
        if (urlResponse.getData() == null || urlResponse.getData().length == 0) {
            return null;
        }
        String string = urlResponse.getContentType();
        if (string == null || !string.contains("application/json")) {
            return null;
        }
        String string2 = new String(urlResponse.getData(), "UTF-8");
        return new JSONObject(string2);
    }

    void a(UrlResponse urlResponse) {
        String string;
        String string2 = this.getParams().getHeaders().get("Accept");
        if (string2 != null && !HttpUtils.isAcceptableContentType(string2, string = urlResponse.getContentType())) {
            NetworkException networkException = new NetworkException("Incompatible data received. Expected '" + string2 + "' but received '" + string + "'", urlResponse.getRequestedUrl());
            urlResponse.setErrorReceived(networkException);
        }
    }

    protected void print() throws UnsupportedEncodingException {
        Log.d((String)b, (String)("Request " + this.mParams.getMethod() + " at " + this.mParams.getUrl()));
        Log.d((String)b, (String)("Request Headers: " + this.mParams.getHeaders()));
        if (this.mParams.getBody() != null) {
            Log.d((String)b, (String)("Request Body: Size: " + this.mParams.getBody().length + (this.mParams.isBodyReadable() ? "bytes, Content:  " + this.mParams.getBodyAsString() : "")));
        }
    }

    public abstract UrlResponse run();
}

