/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.data.local.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.support.annotation.VisibleForTesting;
import android.util.SparseArray;
import com.inlocomedia.android.core.communication.util.BinaryUtils;
import com.inlocomedia.android.core.data.local.Storage;
import com.inlocomedia.android.core.data.local.StorageEntry;
import com.inlocomedia.android.core.data.local.database.LazyCloseSQLiteOpenHelper;
import com.inlocomedia.android.core.data.local.database.SQLiteDatabaseListener;
import com.inlocomedia.android.core.data.local.database.SQLiteDatabaseWrapper;
import com.inlocomedia.android.core.log.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DatabaseStorage
implements Storage,
SQLiteDatabaseListener {
    private static final String b = Logger.makeTag(DatabaseStorage.class);
    private int c;
    private int d;
    private LazyCloseSQLiteOpenHelper e;
    @VisibleForTesting
    SparseArray<StorageEntry> a;

    public DatabaseStorage(LazyCloseSQLiteOpenHelper lazyCloseSQLiteOpenHelper, int databaseMaxRows, int memoryMaxSize) {
        this.e = lazyCloseSQLiteOpenHelper;
        this.e.setDatabaseListener(this);
        this.a = new SparseArray();
        this.c = databaseMaxRows;
        this.d = memoryMaxSize;
    }

    @Override
    public synchronized boolean insert(int id, Map<String, Serializable> values) {
        StorageEntry storageEntry = (StorageEntry)this.a.get(id);
        if (storageEntry == null) {
            storageEntry = new StorageEntry();
            this.a.put(id, (Object)storageEntry);
        }
        long l = System.currentTimeMillis();
        storageEntry.add(l, values);
        if (this.d()) {
            this.a();
        }
        return true;
    }

    @Override
    public synchronized void trim() {
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.e.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return;
            }
            long l = sQLiteDatabaseWrapper.queryNumEntries("events");
            if (l > (long)this.c) {
                long l2 = l - (long)this.c;
                sQLiteDatabaseWrapper.execSQL(this.a(l2));
            }
            this.e.closeDatabase();
        }
        catch (Throwable throwable) {
            this.e.onUnexpectedError(throwable);
        }
    }

    @Override
    public synchronized void clean() {
        try {
            this.c();
            this.b();
        }
        catch (Throwable throwable) {
            this.e.onUnexpectedError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SparseArray<StorageEntry> dump() {
        try (Cursor cursor = null;){
            SparseArray sparseArray = new SparseArray();
            this.a();
            cursor = this.e();
            if (cursor != null) {
                int n = cursor.getColumnIndex("event_id");
                int n2 = cursor.getColumnIndex("timestamp");
                int n3 = cursor.getColumnIndex("event_values");
                while (cursor.moveToNext()) {
                    int n4 = cursor.getInt(n);
                    long l = cursor.getLong(n2);
                    byte[] byArray = cursor.getBlob(n3);
                    StorageEntry storageEntry = (StorageEntry)sparseArray.get(n4);
                    if (storageEntry == null) {
                        storageEntry = new StorageEntry();
                        sparseArray.put(n4, (Object)storageEntry);
                    }
                    storageEntry.add(l, (Map)BinaryUtils.fromByteArray(byArray));
                }
            }
            this.c();
            SparseArray sparseArray2 = sparseArray;
            return sparseArray2;
        }
    }

    @Override
    public synchronized void onCreate(SQLiteDatabaseWrapper databaseWrapper) {
        try {
            databaseWrapper.execSQL("CREATE TABLE events(_id INTEGER PRIMARY KEY AUTOINCREMENT, timestamp INTEGER, event_id INTEGER NOT NULL, event_values BLOB); ");
        }
        catch (Throwable throwable) {
            this.e.onUnexpectedError(throwable);
        }
    }

    @Override
    public synchronized void onUpgrade(SQLiteDatabaseWrapper databaseWrapper, int oldVersion, int newVersion) {
        this.a(databaseWrapper);
    }

    @Override
    public synchronized void onDowngrade(SQLiteDatabaseWrapper databaseWrapper, int oldVersion, int newVersion) {
        this.a(databaseWrapper);
    }

    private void a(SQLiteDatabaseWrapper sQLiteDatabaseWrapper) {
        try {
            sQLiteDatabaseWrapper.execSQL("DROP TABLE IF EXISTS events");
            this.onCreate(sQLiteDatabaseWrapper);
        }
        catch (Throwable throwable) {
            this.e.onUnexpectedError(throwable);
        }
    }

    private void a() {
        SparseArray sparseArray = this.a.clone();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            StorageEntry storageEntry = (StorageEntry)sparseArray.get(n);
            this.a(n, storageEntry);
        }
        this.b();
    }

    private void b() {
        this.a.clear();
    }

    private void c() {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.e.openDatabase();
        if (sQLiteDatabaseWrapper != null) {
            sQLiteDatabaseWrapper.deleteAll("events");
        }
        this.e.closeDatabase();
    }

    private void a(int n, StorageEntry storageEntry) {
        List<Map<String, Serializable>> list = storageEntry.getValuesList();
        for (Map<String, Serializable> map : list) {
            this.a(n, map, storageEntry.getTimestampFromValues(map));
        }
    }

    private void a(int n, Map<String, Serializable> map, long l) {
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.e.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return;
            }
            ContentValues contentValues = this.b(n, map, l);
            sQLiteDatabaseWrapper.insert("events", contentValues);
            this.e.closeDatabase();
        }
        catch (Throwable throwable) {
            this.e.onUnexpectedError(throwable);
        }
    }

    private boolean d() {
        return this.a.size() >= this.d;
    }

    private ContentValues b(int n, Map<String, Serializable> map, long l) throws IOException {
        ContentValues contentValues = new ContentValues();
        contentValues.put("event_id", Integer.valueOf(n));
        contentValues.put("timestamp", Long.valueOf(l));
        byte[] byArray = BinaryUtils.toByteArray(map);
        contentValues.put("event_values", byArray);
        return contentValues;
    }

    private Cursor e() {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.e.openDatabase();
        if (sQLiteDatabaseWrapper == null) {
            return null;
        }
        Cursor cursor = sQLiteDatabaseWrapper.queryAll("events");
        this.e.closeDatabase();
        return cursor;
    }

    @VisibleForTesting(otherwise=2)
    String a(long l) {
        String string = "SELECT event_id FROM events ORDER BY timestamp ASC LIMIT " + l;
        String string2 = "DELETE FROM %s WHERE %s IN (" + string + ");";
        return String.format(string2, "events", "event_id");
    }
}

