/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.log;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.inlocomedia.android.core.data.local.database.LazyCloseSQLiteOpenHelper;
import com.inlocomedia.android.core.data.local.database.SQLiteDatabaseListener;
import com.inlocomedia.android.core.data.local.database.SQLiteDatabaseWrapper;
import com.inlocomedia.android.core.log.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class FileLogger
implements SQLiteDatabaseListener {
    private static final String a = Logger.makeTag(FileLogger.class);
    @SuppressLint(value={"SimpleDateFormat"})
    private static final DateFormat b = new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss.SSS");
    private LazyCloseSQLiteOpenHelper c;
    private static FileLogger d;

    private FileLogger(Context context, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.c = new LazyCloseSQLiteOpenHelper(context, "inlocomedia_eoitnhdentuiolceaoafdsfasueid", null, 1, exceptionHandler);
        this.c.setDatabaseListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FileLogger a(Context context) {
        if (d != null) return d;
        Class<FileLogger> clazz = FileLogger.class;
        synchronized (FileLogger.class) {
            if (d != null) return d;
            d = new FileLogger(context, new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable ex) {
                    throw new RuntimeException(ex);
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return d;
        }
    }

    @Override
    public synchronized void onCreate(SQLiteDatabaseWrapper db) {
        try {
            db.execSQL("CREATE TABLE entries(_id INTEGER PRIMARY KEY AUTOINCREMENT, date INTEGER, message TEXT);");
        }
        catch (Throwable throwable) {
            this.c.onUnexpectedError(throwable);
        }
    }

    @Override
    public synchronized void onUpgrade(SQLiteDatabaseWrapper db, int oldVersion, int newVersion) {
        try {
            db.execSQL("DROP TABLE IF EXISTS entries");
            this.onCreate(db);
        }
        catch (Throwable throwable) {
            this.c.onUnexpectedError(throwable);
        }
    }

    @Override
    public synchronized void onDowngrade(SQLiteDatabaseWrapper db, int oldVersion, int newVersion) {
        try {
            db.execSQL("DROP TABLE IF EXISTS entries");
            this.onCreate(db);
        }
        catch (Throwable throwable) {
            this.c.onUnexpectedError(throwable);
        }
    }

    public static void clearDatabase(Context context) {
        FileLogger fileLogger = FileLogger.a(context);
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = fileLogger.c.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                return;
            }
            sQLiteDatabaseWrapper.delete("entries", null, null);
            fileLogger.c.closeDatabase();
        }
        catch (Throwable throwable) {
            fileLogger.c.onUnexpectedError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static synchronized List<LogEntry> getEntries(Context context) {
        Cursor cursor = null;
        ArrayList<LogEntry> arrayList = new ArrayList<LogEntry>();
        FileLogger fileLogger = FileLogger.a(context);
        try {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = fileLogger.c.openDatabase();
            if (sQLiteDatabaseWrapper == null) {
                List<LogEntry> list = null;
                return list;
            }
            cursor = sQLiteDatabaseWrapper.query("entries", null, null, null, null, null, null);
            int n = cursor.getColumnIndex("date");
            int n2 = cursor.getColumnIndex("message");
            while (cursor.moveToNext()) {
                LogEntry logEntry = new LogEntry(cursor.getLong(n), cursor.getString(n2));
                arrayList.add(0, logEntry);
            }
            Collections.sort(arrayList, new Comparator<LogEntry>(){

                public int a(LogEntry logEntry, LogEntry logEntry2) {
                    long l = logEntry2.date;
                    long l2 = logEntry.date;
                    if (l > l2) {
                        return 1;
                    }
                    if (l2 > l) {
                        return -1;
                    }
                    return 0;
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((LogEntry)object, (LogEntry)object2);
                }
            });
        }
        catch (Throwable throwable) {
            fileLogger.c.onUnexpectedError(throwable);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            fileLogger.c.closeDatabase();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void dumpToFile(Context context) {
        BufferedWriter bufferedWriter = null;
        try {
            File file = Environment.getExternalStorageDirectory();
            File file2 = new File(file.getAbsolutePath() + "/inlocomedia_logs/");
            boolean bl = file2.mkdirs();
            if (!bl && !file2.exists()) {
                throw new IllegalStateException("Failed to create log file at: " + file2);
            }
            List<LogEntry> list = FileLogger.getEntries(context);
            File file3 = new File(file2, "sdk_logs");
            if (file3.exists()) {
                file3.delete();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(file3, true));
            if (list != null) {
                for (LogEntry logEntry : list) {
                    bufferedWriter.write(b.format(new Date(logEntry.date)));
                    bufferedWriter.write(": ");
                    bufferedWriter.write(logEntry.message);
                    bufferedWriter.write("\n");
                }
            }
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            Log.w((String)a, (Throwable)exception);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @VisibleForTesting
    public static void reset(Context context) {
        if (d != null) {
            FileLogger fileLogger = FileLogger.a(context);
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = fileLogger.c.openDatabase();
            if (sQLiteDatabaseWrapper != null) {
                sQLiteDatabaseWrapper.execSQL("DROP TABLE IF EXISTS entries");
            }
            fileLogger.c.closeDatabase();
            fileLogger.c.closeNow();
            d = null;
        }
    }

    public static void insert(Context context, String message) {
    }

    public static class LogEntry {
        public final long date;
        public final String message;

        LogEntry(long date, String message) {
            this.date = date;
            this.message = message;
        }
    }
}

