/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.log;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.Module;
import com.inlocomedia.android.core.annotations.AccessedByTests;
import com.inlocomedia.android.core.communication.APIConstants;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.config.DataControllerConfig;
import com.inlocomedia.android.core.data.local.database.DatabaseStorage;
import com.inlocomedia.android.core.data.local.database.LazyCloseSQLiteOpenHelper;
import com.inlocomedia.android.core.data.remote.DataController;
import com.inlocomedia.android.core.data.remote.DataRequestor;
import com.inlocomedia.android.core.data.remote.JSONProcessor;
import com.inlocomedia.android.core.exception.ErrorHandlerManager;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.profile.Device;
import com.inlocomedia.android.core.util.SaltedDelayedTask;
import com.inlocomedia.android.core.util.ThreadPool;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public class CriticalErrorManager
implements Thread.UncaughtExceptionHandler {
    private static final String a = Logger.makeTag(CriticalErrorManager.class);
    private static final DateFormat b = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
    @AccessedByTests
    private static final ErrorHandlerManager c;
    private Context d;
    private final Map<String, Serializable> e;
    @AccessedByTests
    private SaltedDelayedTask f;
    @AccessedByTests
    private static AtomicReference<CriticalErrorManager> g;
    @AccessedByTests
    private DataController h;

    private CriticalErrorManager(@NonNull Context context, DataControllerConfig config) {
        this.d = context.getApplicationContext();
        this.e = new HashMap<String, Serializable>();
        if (config == null) {
            config = new DataControllerConfig();
        }
        config.setService(APIConstants.criticalErrorM());
        LazyCloseSQLiteOpenHelper lazyCloseSQLiteOpenHelper = new LazyCloseSQLiteOpenHelper(context, "InLocoMediaCriticalError", null, 1, this);
        DatabaseStorage databaseStorage = new DatabaseStorage(lazyCloseSQLiteOpenHelper, config.getMaxDatabaseRows(), config.getMaxMemorySize());
        DataRequestor dataRequestor = new DataRequestor(context, c);
        JSONProcessor jSONProcessor = new JSONProcessor();
        this.h = new DataController.Builder().setContext(context).setDataControllerConfig(config).setStorage(databaseStorage).setProcessor(jSONProcessor).setRequestor(dataRequestor).setId("InLocoMediaCriticalErrorLogs").setUncaughtExceptionHandler(this).build();
    }

    @VisibleForTesting
    public static CriticalErrorManager getInstance(Context context) {
        CriticalErrorManager criticalErrorManager = g.get();
        if (criticalErrorManager == null) {
            g.compareAndSet(null, new CriticalErrorManager(context, null));
            criticalErrorManager = g.get();
        }
        return criticalErrorManager;
    }

    public static void init(Context context, DataControllerConfig config) {
        CriticalErrorManager criticalErrorManager = g.get();
        if (criticalErrorManager == null) {
            g.compareAndSet(null, new CriticalErrorManager(context, config));
        }
    }

    public static synchronized void start(Context context) {
        try {
            final CriticalErrorManager criticalErrorManager = CriticalErrorManager.getInstance(context);
            if (criticalErrorManager.f != null) {
                criticalErrorManager.f.invalidate();
            }
            criticalErrorManager.f = new SaltedDelayedTask(){

                @Override
                protected void runDelayed() {
                    try {
                        if (Environment.CoreModulesManager.ERROR_UPLOAD.isValid()) {
                            criticalErrorManager.h.enableTransmissionsInterval(true);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                @Override
                protected void onError(Throwable t) {
                }
            };
            criticalErrorManager.f.start(a);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void addExtraParam(Context context, String key, Serializable value) {
        CriticalErrorManager.getInstance((Context)context).e.put(key, value);
    }

    @VisibleForTesting
    public static synchronized void reset() {
        CriticalErrorManager criticalErrorManager = g.get();
        if (criticalErrorManager != null) {
            if (criticalErrorManager.f != null) {
                criticalErrorManager.f.invalidateOrWaitIfRunning();
                criticalErrorManager.f = null;
            }
            g.set(null);
        }
    }

    public static void notifyError(String tag, Throwable e, Module module) {
        CriticalErrorManager.notifyError(tag, e, module, true, null);
    }

    public static void notifyError(String tag, Throwable e, Module module, boolean uploadNow) {
        CriticalErrorManager.notifyError(tag, e, module, uploadNow, null);
    }

    public static void notifyError(final String tag, final Throwable e, final Module module, final boolean uploadNow, final @Nullable RequestListener<byte[]> listener) {
        Logger.a(tag, e);
        ThreadPool.executeInBackground(new Runnable(){

            @Override
            public void run() {
                block10: {
                    if (module.isValidAndInvalidate()) {
                        try {
                            module.setInvalid();
                            CriticalErrorManager criticalErrorManager = (CriticalErrorManager)g.get();
                            if (criticalErrorManager == null) {
                                if (listener != null) {
                                    listener.onRequestFailed(new InLocoMediaException("CriticalErrorManager not initialized before trying to notify a error. The error won't be stored"));
                                }
                                return;
                            }
                            if (Environment.isProductionEnvironment()) {
                                criticalErrorManager.a(tag, e, module, uploadNow, listener);
                            } else if (listener != null) {
                                listener.onRequestFailed(new InLocoMediaException("Environment state may be Production."));
                            }
                            break block10;
                        }
                        catch (Throwable throwable) {
                            if (listener != null) {
                                listener.onRequestFailed(new InLocoMediaException("Notify error has failed", throwable));
                            }
                            break block10;
                        }
                    }
                    if (listener != null) {
                        listener.onRequestFailed(new InLocoMediaException("Invalid module"));
                    }
                }
            }
        });
    }

    private void a(final String string, final Throwable throwable, final Module module, final boolean bl, final @Nullable RequestListener<byte[]> requestListener) {
        ThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        if (Environment.CoreModulesManager.ERROR_UPLOAD.isValid()) {
                            Map map = CriticalErrorManager.this.a(string, module, InLocoMediaException.getFormattedMessage(throwable), CriticalErrorManager.b(throwable));
                            CriticalErrorManager.this.h.addEvent(0, map, bl, requestListener);
                        } else if (requestListener != null) {
                            requestListener.onRequestFailed(new InLocoMediaException("Invalid ERROR_UPLOAD module"));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (requestListener == null) break block5;
                        requestListener.onRequestFailed(new InLocoMediaException("Critical Error insertion has failed", throwable2));
                    }
                }
            }
        });
    }

    private Map<String, Serializable> a(String string, Module module, String string2, String string3) {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("type", (Serializable)((Object)"sdk_error_log"));
        hashMap.put("app_package_name", (Serializable)((Object)this.d.getPackageName()));
        hashMap.put("sdk_code_version", Integer.valueOf(30000));
        hashMap.put("sdt", (Serializable)((Object)b.format(new Date(System.currentTimeMillis()))));
        hashMap.put("tag", (Serializable)((Object)string.replace(' ', '_').replace('\t', '_')));
        hashMap.put("error_msg", (Serializable)((Object)string2));
        hashMap.put("stacktrace", (Serializable)((Object)string3));
        hashMap.put("module", (Serializable)((Object)String.valueOf(module)));
        hashMap.put("sender_name", (Serializable)((Object)"Android-API"));
        this.a(hashMap);
        hashMap.putAll(this.e);
        return hashMap;
    }

    private void a(Map<String, Serializable> map) {
        map.put("os", (Serializable)((Object)"android"));
        map.put("os_version", (Serializable)((Object)String.valueOf(Device.ANDROID_VERSION_CODE)));
        map.put("device_model", (Serializable)((Object)Device.MODEL));
        map.put("device_manufacturer", (Serializable)((Object)Device.MANUFACTURER));
        map.put("mad_id", (Serializable)((Object)Device.getAdOrDeviceId(this.d)));
        map.put("google_aid", (Serializable)((Object)Device.getGoogleAdvertisingId(this.d)));
        map.put("ilm_id", (Serializable)((Object)Device.getDeviceId(this.d)));
    }

    private static String b(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (Environment.CoreModulesManager.ERROR_UPLOAD.isValidAndInvalidate()) {
            // empty if block
        }
    }

    public static Serializable getExtraParamValue(Context context, String key) {
        return CriticalErrorManager.getInstance((Context)context).e.get(key);
    }

    static {
        b.setTimeZone(TimeZone.getTimeZone("UTC"));
        c = new ErrorHandlerManager();
        g = new AtomicReference();
    }
}

