/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.support.annotation.Nullable;
import com.inlocomedia.android.core.communication.util.URIBuilder;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.json.JSONException;

public final class UrlUtils {
    private UrlUtils() {
    }

    public static HashMap<String, Object> extractParamsFromUrl(String url) throws URISyntaxException {
        return UrlUtils.extractParamsFromURI(new URI(url));
    }

    public static HashMap<String, Object> extractParamsFromQuery(String query) {
        URI uRI = URI.create("localhost?" + UrlUtils.a(query, null));
        return UrlUtils.extractParamsFromURI(uRI);
    }

    public static HashMap<String, Object> extractParamsFromURI(URI uri) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List<NameValuePair> list = UrlUtils.parseParams(uri);
        for (NameValuePair nameValuePair : list) {
            Object object;
            Object object2;
            String string = UrlUtils.a(nameValuePair.getName(), "UTF-8");
            String string2 = nameValuePair.getValue();
            if (string2.contains(",")) {
                String[] stringArray;
                object2 = new ArrayList();
                object = stringArray = string2.split(",");
                int n = ((String[])object).length;
                for (int i = 0; i < n; ++i) {
                    String string3 = object[i];
                    object2.add(UrlUtils.a(string3, "UTF-8"));
                }
                hashMap.put(string, object2);
                continue;
            }
            object2 = string;
            boolean bl = false;
            if (string.endsWith("[]")) {
                object2 = string.substring(0, string.length() - "[]".length());
                bl = true;
            }
            if ((object = hashMap.get(object2)) != null) {
                if (object instanceof List) {
                    List list2 = (List)object;
                    list2.add(UrlUtils.a(string2, "UTF-8"));
                    continue;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add((String)object);
                arrayList.add(UrlUtils.a(string2, "UTF-8"));
                hashMap.put((String)object2, arrayList);
                continue;
            }
            if (bl) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(UrlUtils.a(string2, "UTF-8"));
                hashMap.put((String)object2, arrayList);
                continue;
            }
            hashMap.put((String)object2, UrlUtils.a(string2, "UTF-8"));
        }
        return hashMap;
    }

    public static String appendParamsToUrl(String url, @Nullable Map<String, Object> params) throws UnsupportedEncodingException, JSONException {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        return URIBuilder.appendQueryToUrl(url, params);
    }

    public static List<NameValuePair> parseParams(URI uri) {
        List<NameValuePair> list = Collections.emptyList();
        String string = uri.getRawQuery();
        if (string != null && string.length() > 0) {
            list = new ArrayList<NameValuePair>();
            UrlUtils.a(list, new Scanner(string));
        }
        return list;
    }

    private static void a(List<NameValuePair> list, Scanner scanner) {
        scanner.useDelimiter("&");
        while (scanner.hasNext()) {
            String[] stringArray = scanner.next().split("=");
            if (stringArray.length == 0 || stringArray.length > 2) {
                throw new IllegalArgumentException("bad parameter");
            }
            String string = stringArray[0];
            String string2 = stringArray.length == 2 ? stringArray[1] : null;
            list.add(new NameValuePair(string, string2));
        }
    }

    private static String a(String string, String string2) {
        try {
            return URLDecoder.decode(string, string2 != null ? string2 : "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
    }

    public static class NameValuePair
    implements Serializable {
        private String a = null;
        private String b = null;

        public NameValuePair(String name, String value) {
            this.a = name;
            this.b = value;
        }

        public String getName() {
            return this.a;
        }

        public void setName(String name) {
            this.a = name;
        }

        public String getValue() {
            return this.b;
        }

        public void setValue(String value) {
            this.b = value;
        }

        public String toString() {
            return "name=" + this.a + ", value=" + this.b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NameValuePair)) {
                return false;
            }
            NameValuePair nameValuePair = (NameValuePair)o;
            if (this.a != null ? !this.a.equals(nameValuePair.a) : nameValuePair.a != null) {
                return false;
            }
            return !(this.b == null ? nameValuePair.b != null : !this.b.equals(nameValuePair.b));
        }

        public int hashCode() {
            int n = this.a != null ? this.a.hashCode() : 0;
            n = 31 * n + (this.b != null ? this.b.hashCode() : 0);
            return n;
        }
    }
}

