/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.os.Handler;
import android.os.Looper;
import com.inlocomedia.android.core.util.DefaultThreadFactory;
import com.inlocomedia.android.core.util.Validator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadPool {
    public static String THREADS_PREFIX = "InLocoMedia";
    private static ScheduledExecutorService a;
    private static ThreadPoolExecutor b;
    private static ThreadPoolExecutor c;
    private static Handler d;

    private ThreadPool() {
    }

    public static void execute(Runnable task, boolean usingLimitedPool) {
        if (usingLimitedPool) {
            c.execute(task);
        } else {
            b.execute(task);
        }
    }

    public static void execute(Runnable task) {
        b.submit(task);
    }

    public static void execute(final Runnable task, final Thread.UncaughtExceptionHandler error) {
        b.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                catch (Throwable throwable) {
                    error.uncaughtException(Thread.currentThread(), throwable);
                }
            }
        });
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return ThreadPool.submit(task, false);
    }

    public static <T> Future<T> submit(Callable<T> command, boolean usingLimitedPool) {
        if (usingLimitedPool) {
            return c.submit(command);
        }
        return b.submit(command);
    }

    public static void executeInBackground(Runnable runnable) {
        if (Validator.isMainThread()) {
            ThreadPool.execute(runnable);
        } else {
            runnable.run();
        }
    }

    public static void executeInMain(Runnable runnable) {
        if (!Validator.isMainThread()) {
            ThreadPool.executeInMainAt(runnable, 0L, TimeUnit.MILLISECONDS);
        } else {
            runnable.run();
        }
    }

    public static void postOnMain(Runnable runnable) {
        ThreadPool.executeInMainAt(runnable, 0L, TimeUnit.MILLISECONDS);
    }

    public static void executeInMainAt(Runnable runnable, long delay, TimeUnit timeUnit) {
        if (timeUnit != TimeUnit.MILLISECONDS) {
            delay = timeUnit.toMillis(delay);
        }
        if (delay > 0L) {
            d.postDelayed(runnable, delay);
        } else {
            d.post(runnable);
        }
    }

    public static ScheduledFuture<?> executeAt(Runnable command, long delay, TimeUnit unit) {
        return a.schedule(command, delay, unit);
    }

    public static ScheduledFuture<?> executeAt(Runnable command, long delayInMillis) {
        return a.schedule(command, delayInMillis, TimeUnit.MILLISECONDS);
    }

    private static void a() {
        b = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory(THREADS_PREFIX + "_MainPool"));
        c = new ThreadPoolExecutor(2, 6, 60L, TimeUnit.SECONDS, new a<Runnable>(), new DefaultThreadFactory(THREADS_PREFIX + "_ImageLoader"), new b());
    }

    private static void b() {
        ThreadPool.a();
        a = Executors.newSingleThreadScheduledExecutor();
        d = new Handler(Looper.getMainLooper());
    }

    public static void waitForThreadsToFinish() throws InterruptedException {
        b.shutdownNow();
        b.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        c.shutdownNow();
        c.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        ThreadPool.a();
    }

    public static ThreadPoolExecutor cacheExecutor() {
        return new ThreadPoolExecutor(1, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(THREADS_PREFIX + "_Cache"));
    }

    static {
        ThreadPool.b();
    }

    private static class b
    implements RejectedExecutionHandler {
        private b() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class a<T>
    extends LinkedBlockingQueue<T> {
        private a() {
        }

        @Override
        public boolean offer(T e) {
            return this.size() <= 1 && super.offer(e);
        }
    }
}

