/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.support.annotation.NonNull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamHelper {
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    private StreamHelper() {
    }

    public static String toString(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return new String(StreamHelper.toByteArray(in));
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long l = StreamHelper.copyLarge(input, output);
        if (l > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        try {
            int n;
            byte[] byArray = new byte[4096];
            long l = 0L;
            while (-1 != (n = input.read(byArray))) {
                output.write(byArray, 0, n);
                l += (long)n;
            }
            long l2 = l;
            return l2;
        }
        finally {
            StreamHelper.close(input);
        }
    }

    public static InputStream fromBytes(byte[] array) {
        return new ByteArrayInputStream(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(@NonNull InputStream is) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = null;
        try {
            int n;
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = is.read(byArray2, 0, byArray2.length)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        finally {
            StreamHelper.close(byteArrayOutputStream);
            StreamHelper.close(is);
        }
        return byArray;
    }

    public static void close(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

