/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.util.Log;
import com.inlocomedia.android.core.log.Logger;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonUtils {
    private static final String a = Logger.makeTag(JsonUtils.class);

    private JsonUtils() {
    }

    public static void print(String tag, JSONObject json) {
        try {
            Log.d((String)tag, (String)json.toString(1));
        }
        catch (JSONException jSONException) {
            Log.w((String)a, (String)json.toString());
        }
    }

    public static JSONObject toJsonObject(byte[] array) throws JSONException, UnsupportedEncodingException {
        String string = new String(array, "UTF-8");
        return new JSONObject(string);
    }

    public static JSONArray toJsonArray(byte[] array) throws JSONException {
        String string = Arrays.toString(array);
        return new JSONArray(string);
    }

    public static HashMap<String, Object> toHash(JSONObject json) throws JSONException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = json.keys();
        while (iterator.hasNext()) {
            int n;
            Object[] objectArray;
            Object object;
            String string = (String)iterator.next();
            Object object2 = json.get(string);
            if (object2 instanceof JSONArray) {
                object = (JSONArray)object2;
                objectArray = new Object[object.length()];
                for (n = 0; n < object.length(); ++n) {
                    objectArray[n] = object.get(n);
                }
                hashMap.put(string, objectArray);
                continue;
            }
            if (object2 instanceof Collection) {
                object = (Collection)object2;
                objectArray = new Object[object.size()];
                n = 0;
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    objectArray[n] = e;
                    ++n;
                }
                hashMap.put(string, objectArray);
                continue;
            }
            hashMap.put(string, object2.toString());
        }
        return hashMap;
    }

    public static List<String> toStringList(JSONArray jsonArray) throws JSONException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                arrayList.add(jsonArray.optString(i));
            }
        }
        return arrayList;
    }
}

