/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.widget.ImageView;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.R;
import com.inlocomedia.android.core.RequestApi;
import com.inlocomedia.android.core.communication.Request;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.exception.InLocoMediaUnhandledException;
import com.inlocomedia.android.core.log.CriticalErrorManager;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.ImageHelper;
import com.inlocomedia.android.core.util.MemoryCache;
import com.inlocomedia.android.core.util.ThreadPool;
import java.lang.ref.WeakReference;

@TargetApi(value=14)
public final class ImageViewDownloadManager {
    private static final String a = Logger.makeTag(ImageViewDownloadManager.class);
    private static final int b = R.id.ilm_private_id_url;
    private static final int c = R.id.ilm_private_id_recycled;
    private static final int d = R.id.ilm_private_id_placeholder;
    private static final int e = R.id.ilm_private_id_request;
    private static final int f = R.id.ilm_private_id_request_listener;
    private static final int g = R.id.ilm_private_id_user_listener;

    private ImageViewDownloadManager() {
    }

    public static boolean downloadAndSet(@NonNull ImageView imageView, @NonNull String imageUrl) {
        return ImageViewDownloadManager.downloadAndSet(imageView, imageUrl, null);
    }

    public static boolean downloadAndSet(@NonNull ImageView imageView, @NonNull String imageUrl, RequestListener<Void> listener) {
        try {
            if (imageUrl.equals(imageView.getTag(b))) {
                return false;
            }
            ImageViewDownloadManager.d(imageView);
            ImageViewDownloadManager.b(imageView, imageUrl);
            ImageViewDownloadManager.a(imageView, listener);
            ImageViewDownloadManager.e(imageView);
            String string = ImageViewDownloadManager.c(imageView, imageUrl);
            Bitmap bitmap = MemoryCache.getInstance().get(string);
            if (bitmap != null) {
                imageView.setImageBitmap(bitmap);
                return false;
            }
            a a2 = new a(imageView, imageUrl);
            imageView.setTag(f, (Object)a2);
            imageView.setTag(e, (Object)RequestApi.requestBitmap(imageView.getContext(), imageUrl, a2, string));
            return true;
        }
        catch (Throwable throwable) {
            CriticalErrorManager.notifyError(a, throwable, Environment.CoreModulesManager.SDK, true);
            return false;
        }
    }

    private static void d(@NonNull ImageView imageView) {
        try {
            a a2;
            Request request = (Request)imageView.getTag(e);
            if (request != null) {
                request.cancel();
            }
            if ((a2 = (a)imageView.getTag(f)) != null) {
                a2.a();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void a(@NonNull ImageView imageView, @NonNull RequestListener<Void> requestListener) {
        imageView.setTag(g, requestListener);
    }

    private static void b(@NonNull ImageView imageView, @NonNull String string) {
        imageView.setTag(b, (Object)string);
    }

    private static void e(@NonNull ImageView imageView) {
        try {
            boolean bl;
            boolean bl2 = bl = imageView.getTag(c) != null;
            if (!bl) {
                imageView.setTag(c, (Object)true);
                Drawable drawable = imageView.getDrawable();
                if (drawable != null) {
                    imageView.setTag(d, (Object)drawable.getConstantState());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void f(final @NonNull ImageView imageView) {
        ThreadPool.executeInMain(new Runnable(){

            @Override
            public void run() {
                try {
                    Drawable drawable = ImageViewDownloadManager.g(imageView);
                    if (drawable != null) {
                        imageView.setImageDrawable(drawable);
                        ImageViewDownloadManager.c(imageView, true);
                    } else {
                        ImageViewDownloadManager.d(imageView, false);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    @Nullable
    private static Drawable g(@NonNull ImageView imageView) {
        try {
            Drawable.ConstantState constantState = (Drawable.ConstantState)imageView.getTag(d);
            if (constantState != null) {
                return constantState.newDrawable();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String c(ImageView imageView, String string) {
        return String.format("%d_%s", imageView.getId(), string);
    }

    private static void c(@NonNull ImageView imageView, boolean bl) {
        if (bl) {
            ViewPropertyAnimator viewPropertyAnimator = imageView.animate();
            viewPropertyAnimator.cancel();
            imageView.setAlpha(0.0f);
            viewPropertyAnimator.alpha(1.0f).start();
        } else {
            imageView.setAlpha(1.0f);
        }
    }

    private static void d(ImageView imageView, boolean bl) {
        if (bl) {
            ViewPropertyAnimator viewPropertyAnimator = imageView.animate();
            viewPropertyAnimator.cancel();
            viewPropertyAnimator.alpha(0.0f).start();
        } else {
            imageView.setAlpha(0.0f);
        }
    }

    private static void b(final @NonNull ImageView imageView, final InLocoMediaException inLocoMediaException) {
        ThreadPool.executeInMain(new Runnable(){

            @Override
            public void run() {
                RequestListener requestListener = (RequestListener)imageView.getTag(g);
                if (requestListener != null) {
                    requestListener.onRequestFailed(inLocoMediaException);
                }
            }
        });
    }

    private static void h(final @Nullable ImageView imageView) {
        ThreadPool.executeInMain(new Runnable(){

            @Override
            public void run() {
                RequestListener requestListener = (RequestListener)imageView.getTag(g);
                if (requestListener != null) {
                    requestListener.onRequestFinished(null);
                }
            }
        });
    }

    private static class a
    implements RequestListener<Bitmap> {
        private final WeakReference<ImageView> a;
        private final String b;
        private boolean c;

        public a(ImageView imageView, String string) {
            this.a = new WeakReference<ImageView>(imageView);
            this.b = string;
            this.c = false;
        }

        public void a(Bitmap bitmap) {
            block4: {
                if (this.c) {
                    return;
                }
                try {
                    ImageView imageView = (ImageView)this.a.get();
                    if (imageView == null || imageView.getTag(b) == null || !imageView.getTag(b).equals(this.b)) {
                        return;
                    }
                    imageView.setTag(b, null);
                    final Bitmap bitmap2 = ImageHelper.getScaledBitmapToFitView(bitmap, (View)imageView);
                    MemoryCache.getInstance().put(ImageViewDownloadManager.c(imageView, this.b), bitmap2);
                    ThreadPool.executeInMain(new Runnable(){

                        @Override
                        public void run() {
                            if (a.this.c) {
                                return;
                            }
                            ImageView imageView = (ImageView)a.this.a.get();
                            if (imageView != null) {
                                try {
                                    imageView.setImageBitmap(bitmap2);
                                }
                                catch (Throwable throwable) {
                                    Log.w((String)a, (String)("Cannot set bitmap. MainQueue.execute() has failed: " + InLocoMediaException.getFormattedMessage(throwable)));
                                    ImageViewDownloadManager.f(imageView);
                                }
                                ImageViewDownloadManager.h(imageView);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    ImageView imageView = (ImageView)this.a.get();
                    if (imageView == null) break block4;
                    ImageViewDownloadManager.f(imageView);
                    ImageViewDownloadManager.b(imageView, new InLocoMediaException("Unhandled error in ImageView loading", throwable));
                    CriticalErrorManager.notifyError(a, throwable, Environment.CoreModulesManager.SDK, true);
                }
            }
        }

        @Override
        public void onRequestFailed(InLocoMediaException error) {
            ImageView imageView;
            if (this.c) {
                return;
            }
            if (error instanceof InLocoMediaUnhandledException && this.a.get() != null) {
                CriticalErrorManager.notifyError(a, error, Environment.CoreModulesManager.SDK, true);
            }
            if ((imageView = (ImageView)this.a.get()) != null) {
                ImageViewDownloadManager.f((ImageView)this.a.get());
                ImageViewDownloadManager.b(imageView, error);
            }
        }

        public void a() {
            this.c = true;
        }

        @Override
        public /* synthetic */ void onRequestFinished(Object object) {
            this.a((Bitmap)object);
        }
    }
}

