/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import com.inlocomedia.android.core.annotations.VisibleForTesting;
import com.inlocomedia.android.core.log.Logger;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;

public final class DependencyHelper {
    @VisibleForTesting
    protected static ConcurrentHashMap<String, Boolean> sClassAvailabilityMap = new ConcurrentHashMap();
    @VisibleForTesting
    protected static ConcurrentHashMap<MethodData, Boolean> sMethodAvailabilityMap = new ConcurrentHashMap();
    private static final String a = Logger.makeTag(DependencyHelper.class);

    public static boolean isClassAvailable(String classPath) {
        Boolean bl;
        if (classPath == null || classPath.trim().isEmpty()) {
            bl = false;
        } else if (sClassAvailabilityMap.containsKey(classPath)) {
            bl = sClassAvailabilityMap.get(classPath);
        } else {
            try {
                Class.forName(classPath);
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
            }
            sClassAvailabilityMap.put(classPath, bl);
        }
        return bl;
    }

    public static boolean isMethodAvailable(String classPath, String methodName, Class<?> ... parameterTypes) {
        Boolean bl;
        if (methodName == null || methodName.trim().isEmpty() || classPath == null || classPath.trim().isEmpty()) {
            bl = false;
        } else {
            MethodData methodData = DependencyHelper.getMethodKey(classPath, methodName, parameterTypes);
            if (sMethodAvailabilityMap.containsKey(methodData)) {
                bl = sMethodAvailabilityMap.get(methodData);
            } else {
                try {
                    Class.forName(classPath).getMethod(methodName, parameterTypes);
                    bl = true;
                }
                catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                    bl = false;
                }
                sMethodAvailabilityMap.put(methodData, bl);
            }
        }
        return bl;
    }

    @VisibleForTesting
    protected static MethodData getMethodKey(String classPath, String methodName, Class<?> ... parameterTypes) {
        return new MethodData(classPath, methodName, parameterTypes);
    }

    public static void reset() {
        sClassAvailabilityMap.clear();
        sMethodAvailabilityMap.clear();
    }

    @VisibleForTesting
    protected static class MethodData {
        private String a;
        private String b;
        private Class<?>[] c;

        MethodData(String classPath, String methodName, Class<?> ... parameterTypes) {
            this.a = classPath;
            this.b = methodName;
            this.c = parameterTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodData methodData = (MethodData)o;
            if (this.a != null ? !this.a.equals(methodData.a) : methodData.a != null) {
                return false;
            }
            if (this.b != null ? !this.b.equals(methodData.b) : methodData.b != null) {
                return false;
            }
            return Arrays.equals(this.c, methodData.c);
        }

        public int hashCode() {
            int n = this.a != null ? this.a.hashCode() : 0;
            n = 31 * n + (this.b != null ? this.b.hashCode() : 0);
            n = 31 * n + Arrays.hashCode(this.c);
            return n;
        }
    }
}

