/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.serialization.json;

import android.content.Context;
import com.inlocomedia.android.core.exception.InvalidMappingException;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.serialization.json.JsonableModel;
import com.inlocomedia.android.core.serialization.json.PersistentJsonableManager;
import com.inlocomedia.android.core.util.Base64Utils;
import com.inlocomedia.android.core.util.CryptographyUtils;
import com.inlocomedia.android.core.util.SharedPreferencesManager;
import java.security.GeneralSecurityException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class PersistentJsonableModel
extends JsonableModel {
    private static final String a = Logger.makeTag(PersistentJsonableModel.class);
    private int b;
    private boolean c;

    public abstract String getUniqueName();

    public long getValidateTime() {
        return 0L;
    }

    protected abstract void onUpgrade(int var1, String var2);

    protected abstract void onDowngrade(int var1, String var2);

    public PersistentJsonableModel(int version) {
        this(version, false);
    }

    public PersistentJsonableModel(int version, boolean encodingEnabled) {
        this.b = version;
        this.c = encodingEnabled;
    }

    protected synchronized boolean save(Context context) {
        boolean bl = false;
        try {
            bl = PersistentJsonableModel.a(this.a(context), (JsonableModel)this, this.b, this.c, "object");
        }
        catch (InvalidMappingException invalidMappingException) {
            // empty catch block
        }
        return bl;
    }

    protected synchronized boolean save(Context context, String key) {
        boolean bl = false;
        try {
            bl = PersistentJsonableModel.a(this.a(context), (JsonableModel)this, this.b, this.c, key);
        }
        catch (InvalidMappingException invalidMappingException) {
            // empty catch block
        }
        return bl;
    }

    protected synchronized boolean restore(Context context) {
        return this.restore(context, "object");
    }

    protected synchronized boolean restore(Context context, String key) {
        SharedPreferencesManager.Entry entry = this.a(context);
        if (!entry.contains("version")) {
            return false;
        }
        try {
            int n = entry.getInt("version", 0);
            if (this.b == n) {
                if (!PersistentJsonableModel.a(entry, (JsonableModel)this, this.b, this.getValidateTime(), key)) {
                    return false;
                }
            } else {
                String string = entry.getString(key, null);
                if (entry.getBoolean("crypt", false)) {
                    string = PersistentJsonableModel.a(entry, string);
                }
                if (this.b > n) {
                    this.onUpgrade(n, string);
                } else {
                    this.onDowngrade(n, string);
                }
                PersistentJsonableModel.a(entry, (JsonableModel)this, this.b, this.c, key);
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    protected synchronized boolean clear(Context context) {
        return this.a(context).clear();
    }

    private SharedPreferencesManager.Entry a(Context context) {
        return SharedPreferencesManager.getInstance(context).getEntry(PersistentJsonableManager.makePrefsName(this.getUniqueName()));
    }

    private static boolean a(SharedPreferencesManager.Entry entry, JsonableModel jsonableModel, int n, boolean bl, String string) throws InvalidMappingException {
        String string2 = jsonableModel.parseToJSON().toString();
        int n2 = 0;
        if (bl) {
            try {
                string2 = CryptographyUtils.encrypt(string2);
                n2 = 1;
            }
            catch (Exception exception) {
                string2 = Base64Utils.encode(string2);
                n2 = 2;
            }
        }
        return entry.put(string, string2).put(PersistentJsonableModel.a(string, "save_timestamp"), System.currentTimeMillis()).put("version", n).put("crypt", bl).put("encoding_type", n2).commit();
    }

    private static String a(String string, String string2) {
        return string + string2;
    }

    private static boolean a(SharedPreferencesManager.Entry entry, JsonableModel jsonableModel, int n, long l, String string) throws GeneralSecurityException, JSONException, InvalidMappingException {
        if (!(entry.contains(string) && entry.contains("version") && entry.contains("crypt"))) {
            throw new InvalidMappingException("The saved model must contain \"version\", \"cryptography_enabled\" and the json \"object\"");
        }
        if (n != entry.getInt("version", 0)) {
            throw new InvalidMappingException("The saved model and the current model has different versions.");
        }
        PersistentJsonableModel.a(entry, string, l);
        String string2 = entry.getString(string, null);
        if (string2 == null) {
            return false;
        }
        if (entry.getBoolean("crypt", false)) {
            string2 = PersistentJsonableModel.a(entry, string2);
        }
        jsonableModel.parseFromJSON(new JSONObject(string2));
        return true;
    }

    private static String a(SharedPreferencesManager.Entry entry, String string) throws GeneralSecurityException {
        int n = entry.getInt("encoding_type", 1);
        switch (n) {
            case 1: {
                string = CryptographyUtils.decrypt(string);
                break;
            }
            case 2: {
                string = Base64Utils.decode(string);
            }
        }
        return string;
    }

    private static void a(SharedPreferencesManager.Entry entry, String string, long l) {
        long l2 = entry.getLong(PersistentJsonableModel.a(string, "save_timestamp"), 0L);
        if (l != 0L && System.currentTimeMillis() - l2 > l) {
            entry.clear();
        }
    }
}

