/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.serialization;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public final class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static Field getField(Class<?> fieldClass, String fieldName) throws NoSuchFieldException {
        try {
            Field field = fieldClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class<?> clazz = fieldClass.getSuperclass();
            if (clazz == null) {
                throw new NoSuchFieldException();
            }
            return ReflectionHelper.getField(clazz, fieldName);
        }
    }

    public static Field[] getAllFields(Class<?> fieldClass) {
        Field[] fieldArray;
        for (Field field : fieldArray = fieldClass.getDeclaredFields()) {
            field.setAccessible(true);
        }
        Class<?> clazz = fieldClass.getSuperclass();
        if (clazz == null) {
            return fieldArray;
        }
        return ReflectionHelper.a(fieldArray, ReflectionHelper.getAllFields(clazz));
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... constructorParamTypes) throws NoSuchMethodException {
        Constructor<T> constructor = clazz.getDeclaredConstructor(constructorParamTypes);
        constructor.setAccessible(true);
        return constructor;
    }

    private static <T> T[] a(T[] TArray, T[] TArray2) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        System.arraycopy(TArray2, 0, objectArray, TArray.length, TArray2.length);
        return objectArray;
    }
}

