/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.log;

import android.content.Context;
import android.util.Log;
import com.inlocomedia.android.core.AppContext;
import com.inlocomedia.android.core.log.FileLogger;

public final class Logger {
    public static final String TAG = "InLocoMedia";

    private Logger() {
    }

    public static String makeTag(String tag) {
        return "InLocoMedia:" + tag;
    }

    public static String makeTag(Class<?> klass) {
        return "InLocoMedia:" + klass.getSimpleName();
    }

    public static void e(Context context, String tag, String message, Throwable e) {
        Log.e((String)tag, (String)message, (Throwable)e);
        FileLogger.insert(context, message);
    }

    public static void e(String tag, String message, Throwable e) {
        Log.e((String)tag, (String)message, (Throwable)e);
    }

    public static void e(String tag, String message) {
        Log.e((String)tag, (String)message);
    }

    public static void w(String tag, String message, Exception e) {
        Log.w((String)tag, (String)message, (Throwable)e);
    }

    public static void w(String tag, String message) {
        Log.w((String)tag, (String)message);
    }

    public static void i(String tag, String message) {
        Log.i((String)tag, (String)message);
    }

    public static void d(String tag, String message) {
        Log.d((String)tag, (String)message);
    }

    public static void w(Context context, String tag, String message) {
        Log.w((String)tag, (String)message);
        FileLogger.insert(context, message);
    }

    public static void w(Context context, String tag, String message, Throwable t) {
        Log.w((String)tag, (String)message, (Throwable)t);
        FileLogger.insert(context, message);
    }

    public static void i(Context context, String tag, String message) {
        Log.i((String)tag, (String)message);
        FileLogger.insert(context, message);
    }

    public static void d(Context context, String tag, String message) {
        Log.d((String)tag, (String)message);
        FileLogger.insert(context, message);
    }

    public static void wtf(String tag, Throwable e) {
        if (AppContext.sContext != null) {
            Logger.e(AppContext.get(), tag, "InLocoMedia critical error: " + e.getMessage(), e);
        } else {
            Logger.e(tag, "InLocoMedia critical error", e);
        }
    }
}

