/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.log;

import android.content.Context;
import android.support.annotation.Nullable;
import com.inlocomedia.android.core.annotations.AccessedByTests;
import com.inlocomedia.android.core.annotations.VisibleForTesting;
import com.inlocomedia.android.core.communication.amazon.KinesisPutRecords;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.database.IdAndValueList;
import com.inlocomedia.android.core.exception.InLocoMediaUnhandledException;
import com.inlocomedia.android.core.log.Dumpable;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.CryptographyUtils;
import com.inlocomedia.android.core.util.Validator;

public class LogCentralUploader {
    private static final String a = Logger.makeTag(LogCentralUploader.class);
    @AccessedByTests
    private static LogCentralUploader b;

    @VisibleForTesting
    public LogCentralUploader() {
    }

    public static void upload(Context context, Dumpable db, @Nullable RequestListener<Void> listener) {
        if (b == null) {
            b = new LogCentralUploader();
        }
        b.instanceUpload(context, db, listener);
    }

    @VisibleForTesting
    public void instanceUpload(Context context, Dumpable db, @Nullable RequestListener<Void> listener) {
        block6: {
            try {
                if (db != null) {
                    IdAndValueList<String> idAndValueList = db.dump(context, 500);
                    Validator.notNull(idAndValueList, "Database dump: " + db.getClass().getSimpleName());
                    if (idAndValueList.isEmpty()) {
                        if (listener != null) {
                            listener.onRequestFinished(null);
                        }
                        return;
                    }
                    KinesisPutRecords.put(context, "log-central-main-stream", String.valueOf(System.currentTimeMillis()), idAndValueList.getValues(), "us-east-1", CryptographyUtils.decrypt("no4Abp7A9/2niNwro/UCM17FuJTcS/Bg9ciDOJkysv0="), CryptographyUtils.decrypt("QUipyT/TLo210xTFMvdLapKjMMOVxKPo3xQ3uobeHv3gl+3QvDYXPB5NQ9KbpaXD"));
                    db.deleteIn(idAndValueList.getIds());
                    db.cleanup();
                    if (listener != null) {
                        listener.onRequestFinished(null);
                    }
                }
            }
            catch (Throwable throwable) {
                if (listener == null) break block6;
                listener.onRequestFailed(new InLocoMediaUnhandledException(throwable));
            }
        }
    }
}

