/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.log;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.Module;
import com.inlocomedia.android.core.annotations.AccessedByTests;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.LogCentralUploader;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.log.a;
import com.inlocomedia.android.core.util.SaltedDelayedTask;
import com.inlocomedia.android.core.util.ThreadPool;
import java.io.PrintWriter;
import java.io.StringWriter;

public class CriticalErrorManager
implements Thread.UncaughtExceptionHandler {
    private static final String a = Logger.makeTag(CriticalErrorManager.class);
    @AccessedByTests
    private static CriticalErrorManager b;
    @AccessedByTests
    private SaltedDelayedTask c;
    private a d;
    private Context e;

    @VisibleForTesting
    protected static synchronized CriticalErrorManager getInstance(Context context) {
        return CriticalErrorManager.init(context);
    }

    protected CriticalErrorManager(Context context) {
        this.d = new a(context, this);
        this.e = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized CriticalErrorManager init(Context context) {
        if (b != null) return b;
        Class<CriticalErrorManager> clazz = CriticalErrorManager.class;
        synchronized (CriticalErrorManager.class) {
            if (b != null) return b;
            b = new CriticalErrorManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return b;
        }
    }

    public static synchronized void start(Context context, RequestListener<Void> listener) {
        try {
            CriticalErrorManager criticalErrorManager = CriticalErrorManager.getInstance(context);
            if (criticalErrorManager.c != null) {
                criticalErrorManager.c.invalidate();
            }
            criticalErrorManager.startDelayedTask(listener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void addExtraParam(Context context, String key, Object value) {
        CriticalErrorManager.getInstance((Context)context).d.a(key, value);
    }

    @VisibleForTesting
    public static Object getExtraParamValue(Context context, String key) {
        return CriticalErrorManager.getInstance((Context)context).d.b(key);
    }

    @VisibleForTesting
    protected void startDelayedTask(final RequestListener<Void> listener) {
        this.c = new SaltedDelayedTask(){

            @Override
            protected void runDelayed() {
                try {
                    if (Environment.CoreModulesManager.ERROR_UPLOAD.isValid()) {
                        CriticalErrorManager.this.a(listener);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            protected void onError(Throwable t) {
            }
        };
        this.c.start(a);
    }

    @VisibleForTesting
    public static synchronized void reset() {
        if (b != null) {
            if (CriticalErrorManager.b.c != null) {
                CriticalErrorManager.b.c.invalidateOrWaitIfRunning();
                CriticalErrorManager.b.c = null;
            }
            b = null;
        }
    }

    private void a(@Nullable RequestListener<Void> requestListener) {
        LogCentralUploader.upload(this.e, this.d, requestListener);
    }

    public static void notifyError(String tag, Throwable e, Module module) {
        CriticalErrorManager.notifyError(tag, e, module, false, null);
    }

    public static void notifyError(String tag, Throwable e, Module module, boolean uploadNow) {
        CriticalErrorManager.notifyError(tag, e, module, uploadNow, null);
    }

    public static void notifyError(final String tag, final Throwable e, final Module module, final boolean uploadNow, final @Nullable RequestListener<Void> listener) {
        Logger.wtf(tag, e);
        ThreadPool.executeInBackground(new Runnable(){

            @Override
            public void run() {
                block7: {
                    if (module.isValidAndInvalidate()) {
                        try {
                            module.setInvalid();
                            if (b == null || b.e == null) {
                                return;
                            }
                            if (Environment.isProductionEnvironment()) {
                                b.log(tag, e, module, uploadNow, listener);
                            } else if (listener != null) {
                                listener.onRequestFailed(new InLocoMediaException("Environment state may be Production."));
                            }
                        }
                        catch (Throwable throwable) {
                            if (listener == null) break block7;
                            listener.onRequestFailed(new InLocoMediaException("Notify error has failed", throwable));
                        }
                    }
                }
            }
        });
    }

    @VisibleForTesting
    public void log(final String tag, final Throwable t, final Module module, final boolean sendErrors, final @Nullable RequestListener<Void> listener) {
        ThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Environment.CoreModulesManager.ERROR_UPLOAD.isValid()) {
                        boolean bl;
                        long l = CriticalErrorManager.this.d.a(tag, module, InLocoMediaException.getFormattedMessage(t), CriticalErrorManager.b(t));
                        boolean bl2 = bl = l == -1L;
                        if (bl) {
                            if (listener != null) {
                                listener.onRequestFailed(new InLocoMediaException("Database insertion has failed"));
                            }
                        } else if (sendErrors) {
                            CriticalErrorManager.this.a(listener);
                        } else if (listener != null) {
                            listener.onRequestFinished(null);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private static String b(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (Environment.CoreModulesManager.ERROR_UPLOAD.isValidAndInvalidate()) {
            // empty if block
        }
    }
}

