/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.util;

import android.net.Uri;
import android.support.annotation.NonNull;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import org.json.JSONException;

public class URIBuilder {
    private final Uri.Builder a;

    public URIBuilder() {
        this.a = new Uri.Builder();
    }

    public URIBuilder(String url) {
        Uri uri = Uri.parse((String)url);
        this.a = uri.buildUpon();
    }

    public URIBuilder appendQueryParameter(String key, String value) {
        this.a.appendQueryParameter(key, value);
        return this;
    }

    public URIBuilder appendQueryParameter(String key, Object value) {
        return this.appendQueryParameter(key, value.toString());
    }

    public Uri build() {
        return this.a.build();
    }

    public String toString() {
        return this.a.build().toString();
    }

    public static String appendQueryToUrl(@NonNull String url, @NonNull Map<String, Object> params) throws JSONException, UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder(url);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object object;
            String string = entry.getKey();
            Object object2 = entry.getValue();
            if (object2.getClass().isArray()) {
                object = (Object[])object2;
                if (((Object[])object).length <= 0) continue;
                URIBuilder.a(stringBuilder, (Object[])object, string);
                continue;
            }
            if (object2 instanceof Collection) {
                object = (Collection)object2;
                if (object.size() <= 0) continue;
                URIBuilder.a(stringBuilder, object, string);
                continue;
            }
            stringBuilder.append(!stringBuilder.toString().contains("?") ? "?" : "&");
            stringBuilder.append(String.format("%s=%s", URIBuilder.urlEscape(string), URIBuilder.urlEscape(object2.toString())));
        }
        return stringBuilder.toString();
    }

    static void a(StringBuilder stringBuilder, Object[] objectArray, String string) throws UnsupportedEncodingException, JSONException {
        stringBuilder.append(!stringBuilder.toString().contains("?") ? "?" : "&");
        stringBuilder.append(URIBuilder.urlEscape(string)).append("=");
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            stringBuilder.append(URIBuilder.urlEscape(object.toString()));
            if (i + 1 == n) continue;
            stringBuilder.append(',');
        }
    }

    private static void a(StringBuilder stringBuilder, Collection<?> collection, String string) throws UnsupportedEncodingException, JSONException {
        stringBuilder.append(!stringBuilder.toString().contains("?") ? "?" : "&");
        stringBuilder.append(URIBuilder.urlEscape(string)).append("=");
        int n = collection.size();
        int n2 = 0;
        for (Object obj : collection) {
            if (obj != null) {
                stringBuilder.append(URIBuilder.urlEscape(obj.toString()));
                if (n2 + 1 != n) {
                    stringBuilder.append(',');
                }
            }
            ++n2;
        }
    }

    public static String urlEscape(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string, "UTF-8");
    }
}

