/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.inlocomedia.android.core.communication.exception.NetworkUnavailableException;
import com.inlocomedia.android.core.util.Validator;

public final class NetworkAccessTools {
    private NetworkAccessTools() {
    }

    public static boolean isNetworkAvailable(Context context) {
        Validator.notNull(context, "Context");
        NetworkInfo networkInfo = NetworkAccessTools.getActiveNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnectedOrConnecting();
    }

    public static boolean isConnectedViaWifi(Context context) {
        Validator.notNull(context, "Context");
        NetworkInfo networkInfo = NetworkAccessTools.getActiveNetworkInfo(context);
        return networkInfo != null && networkInfo.getType() == 1 && networkInfo.isConnectedOrConnecting();
    }

    public static NetworkInfo getActiveNetworkInfo(Context context) {
        Validator.notNull(context, "Context");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivityManager.getActiveNetworkInfo();
    }

    public static void validateNetworkAvailable(Context context) throws NetworkUnavailableException {
        Validator.notNull(context, "Context");
        if (!NetworkAccessTools.isNetworkAvailable(context)) {
            throw new NetworkUnavailableException();
        }
    }

    public static boolean isConnected(Context context) {
        NetworkInfo networkInfo = NetworkAccessTools.getActiveNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean isConnectedMobile(Context context) {
        NetworkInfo networkInfo = NetworkAccessTools.getActiveNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 0;
    }

    public static boolean isConnectedFast(Context context) {
        NetworkInfo networkInfo = NetworkAccessTools.getActiveNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected() && NetworkAccessTools.isConnectionFast(networkInfo.getType(), networkInfo.getSubtype());
    }

    public static boolean isConnectionFast(int type, int subType) {
        if (type == 1) {
            return true;
        }
        if (type == 0) {
            switch (subType) {
                case 7: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 8: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 11: {
                    return false;
                }
                case 13: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

