/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.util;

import android.content.Context;
import android.util.Base64;
import com.inlocomedia.android.core.communication.util.WebViewHelper;
import java.util.HashMap;

public final class HttpUtils {
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String URL_HEADER_FIELD = "Location";
    public static final String SET_COOKIE_HEADER_FIELD = "Set-Cookie";
    public static final String COOKIE_HEADER_FIELD = "Cookie";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CACHE_CONTROL_NO_CACHE = "no-cache";
    public static final String CACHE_CONTROL_NO_STORE = "no-store";
    public static final String USER_AGENT = "User-Agent";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_ALL = "*/*";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_TEXT = "text/plain";
    public static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    public static final String ACCEPT = "Accept";
    public static final String UTF_8 = "UTF-8";
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";

    private HttpUtils() {
    }

    public static HashMap<String, String> getHeaderGroupForJson() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ACCEPT, CONTENT_TYPE_JSON);
        return hashMap;
    }

    public static HashMap<String, String> getHeaderGroupForAnything() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ACCEPT, CONTENT_TYPE_ALL);
        return hashMap;
    }

    public static HashMap<String, String> getHeaderGroupForHtml(Context context) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ACCEPT, CONTENT_TYPE_TEXT_HTML);
        hashMap.put(USER_AGENT, WebViewHelper.getDefaultUserAgentString(context));
        return hashMap;
    }

    public static HashMap<String, String> getHeaderGroupForImage() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ACCEPT, CONTENT_TYPE_ALL);
        return hashMap;
    }

    public static HashMap<String, String> getHeaderGroupForOauth(String clientId, String clientSecret) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = clientId + ":" + clientSecret;
        String string2 = Base64.encodeToString((byte[])string.getBytes(), (int)2);
        hashMap.put("Authorization", "Basic " + string2 + "==");
        hashMap.put(CONTENT_TYPE, "application/x-www-form-urlencoded;charset=UTF-8");
        return hashMap;
    }

    public static String getOauthBody() {
        return "grant_type=client_credentials";
    }

    public static boolean isAcceptableContentType(String ctExpected, String ctReceived) {
        if (ctExpected == null || ctExpected.equals(CONTENT_TYPE_ALL)) {
            return true;
        }
        if (ctReceived == null) {
            return false;
        }
        String[] stringArray = ctExpected.split("/");
        String[] stringArray2 = ctReceived.split("/");
        return stringArray2[0].matches(stringArray[0]) && stringArray2[1].matches(stringArray[1]);
    }
}

