/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.responses;

import android.util.Log;
import com.inlocomedia.android.core.communication.exception.UnauthorizedException;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.StreamHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class UrlResponse {
    private static final String a = Logger.makeTag(UrlResponse.class);
    private int b;
    private String c;
    private String d;
    private byte[] e;
    private InLocoMediaException f;
    private String g;

    protected UrlResponse() {
    }

    public UrlResponse(byte[] data) throws IllegalStateException, IOException {
        this.e = data;
        this.b = 200;
    }

    public UrlResponse(InLocoMediaException error, String requestedUrl) {
        this.f = error;
        this.e = null;
    }

    public boolean isSuccessful() {
        return this.f == null && this.b >= 200 && this.b <= 299;
    }

    public boolean isRedirectable() {
        return this.b == 302 || this.b == 301 || this.b == 303;
    }

    public boolean isUnauthorized() {
        return this.b == 401 || this.f instanceof UnauthorizedException;
    }

    public byte[] getData() {
        return this.e;
    }

    public InLocoMediaException getErrorReceived() {
        return this.f;
    }

    public boolean hasErrors() {
        return this.f != null;
    }

    public void setErrorReceived(InLocoMediaException errorReceived) {
        this.f = errorReceived;
    }

    public boolean isResponseReadable() {
        return this.d != null && (this.d.contains("application/json") || this.d.contains("text/plain"));
    }

    public String getResponseAsString() throws UnsupportedEncodingException {
        return new String(this.getData(), "UTF-8");
    }

    public void setRequestedUrl(String url) {
        this.g = url;
    }

    public String getRequestedUrl() {
        return this.g;
    }

    public void setStatusCode(int statusCode) {
        this.b = statusCode;
    }

    protected byte[] readResponse(InputStream stream) throws IllegalStateException, IOException {
        if (stream != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamHelper.copy(stream, byteArrayOutputStream);
            this.e = byteArrayOutputStream.toByteArray();
        }
        return this.e;
    }

    public void setContentType(String contentType) {
        this.d = contentType;
    }

    public String getStatusMessage() {
        return this.c;
    }

    public void setStatusMessage(String statusMessage) {
        this.c = statusMessage;
    }

    public int getStatusCode() {
        return this.b;
    }

    public String getContentType() {
        return this.d;
    }

    public void setData(byte[] data) {
        this.e = data;
    }

    public void print() {
        if (this.hasErrors()) {
            Log.w((String)a, (String)("Request error: " + InLocoMediaException.getFormattedMessage(this.getErrorReceived())));
        } else if (this.isResponseReadable()) {
            try {
                Log.d((String)a, (String)("Response: " + this.getResponseAsString()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }
}

