/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.requests.params;

import android.content.Context;
import com.inlocomedia.android.core.communication.util.CacheConfig;
import com.inlocomedia.android.core.communication.util.RestfulMethod;
import com.inlocomedia.android.core.communication.util.URIBuilder;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.Validator;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpRequestParams {
    static final String a = Logger.makeTag(HttpRequestParams.class);
    private String b;
    private String c;
    private byte[] d;
    private HashMap<String, Object> e;
    private HashMap<String, String> f;
    private Context g;
    private CacheConfig h;
    private boolean i;
    private String j;

    public HttpRequestParams(Context context, RestfulMethod restfulMethod) {
        Validator.notNull(context, "Context");
        this.g = context;
        this.f = new HashMap();
        this.h = CacheConfig.getDisabledConfig();
        this.setUrl(restfulMethod.getUrl());
        this.c = restfulMethod.getMethod();
    }

    public HttpRequestParams(Context context, String url) {
        this(context, new RestfulMethod(0, url));
    }

    public byte[] getBody() {
        return this.d;
    }

    public HttpRequestParams setBody(JSONObject body) throws UnsupportedEncodingException {
        this.d = body != null ? body.toString().getBytes("UTF-8") : null;
        this.i = true;
        return this;
    }

    public HttpRequestParams setBody(String body) throws UnsupportedEncodingException {
        this.d = body != null ? body.getBytes("UTF-8") : null;
        this.i = true;
        return this;
    }

    public HttpRequestParams setBody(byte[] body) {
        this.d = body;
        this.i = false;
        return this;
    }

    public String getUrl() {
        return this.j != null ? this.j : this.b;
    }

    public String getMethod() {
        return this.c;
    }

    public HashMap<String, Object> getUrlParams() {
        return this.e;
    }

    public HttpRequestParams setUrlParams(HashMap<String, Object> urlParams) {
        this.e = urlParams;
        return this;
    }

    public void buildUrl() throws UnsupportedEncodingException, JSONException {
        if (this.e != null) {
            this.j = URIBuilder.appendQueryToUrl(this.b, this.e);
        }
    }

    public HashMap<String, String> getHeaders() {
        return this.f;
    }

    public HttpRequestParams setHeaders(HashMap<String, String> headers) {
        this.f = headers;
        return this;
    }

    public HttpRequestParams addHeader(String key, String value) {
        if (this.f == null) {
            this.f = new HashMap();
        }
        this.f.put(key, value);
        return this;
    }

    public Context getContext() {
        return this.g;
    }

    public HttpRequestParams setContext(Context context) {
        this.g = context;
        return this;
    }

    public HttpRequestParams addUrlParam(String key, String value) {
        if (this.e == null) {
            this.e = new HashMap();
        }
        this.e.put(key, value);
        return this;
    }

    public CacheConfig getCacheConfig() {
        return this.h;
    }

    public boolean isCacheEnabled() {
        return this.h != null && this.h.getType() == CacheConfig.Type.DEFAULT;
    }

    public boolean isResponseCacheable() {
        return this.h != null && this.h.getType() != CacheConfig.Type.DISABLED;
    }

    public void setCacheConfig(CacheConfig config) {
        this.h = config;
    }

    public boolean isBodyReadable() {
        return this.i;
    }

    public String getBodyAsString() throws UnsupportedEncodingException {
        return new String(this.d, "UTF-8");
    }

    public void setUrl(String url) {
        this.b = url;
    }
}

