/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.requests;

import android.util.Log;
import com.inlocomedia.android.core.communication.cache.CacheManager;
import com.inlocomedia.android.core.communication.exception.NetworkException;
import com.inlocomedia.android.core.communication.exception.NetworkUnavailableException;
import com.inlocomedia.android.core.communication.exception.TimeoutException;
import com.inlocomedia.android.core.communication.exception.UnauthorizedException;
import com.inlocomedia.android.core.communication.requests.params.HttpRequestParams;
import com.inlocomedia.android.core.communication.responses.UrlResponse;
import com.inlocomedia.android.core.communication.util.HttpUtils;
import com.inlocomedia.android.core.communication.util.LoadState;
import com.inlocomedia.android.core.exception.ErrorHandlerManager;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.exception.InLocoMediaUnhandledException;
import com.inlocomedia.android.core.log.Logger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import org.apache.http.conn.ConnectTimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class HttpRequest {
    static final String a = Logger.makeTag(HttpRequest.class.getSimpleName());
    protected final HttpRequestParams mParams;
    protected final ErrorHandlerManager mErrorHandlerManager;
    protected LoadState mState;

    public HttpRequest(HttpRequestParams params, ErrorHandlerManager errorHandler) {
        this.mParams = params;
        this.mState = LoadState.INACTIVE;
        this.mErrorHandlerManager = errorHandler;
    }

    public void removeCached() {
        if (this.mParams.getCacheConfig().isEnabled()) {
            CacheManager cacheManager = CacheManager.getInstance(this.mParams.getContext());
            cacheManager.clear(this.mParams.getCacheConfig().getKey());
        }
    }

    public void cancel() {
        this.mState = LoadState.CANCELED;
    }

    public boolean isFinished() {
        return this.mState == LoadState.FINISHED;
    }

    public boolean isInactive() {
        return this.mState == LoadState.INACTIVE;
    }

    public boolean isRunning() {
        return this.mState == LoadState.RUNNING;
    }

    public boolean isCanceled() {
        return this.mState == LoadState.CANCELED;
    }

    public void shutdown() {
    }

    public HttpRequestParams getParams() {
        return this.mParams;
    }

    public LoadState getState() {
        return this.mState;
    }

    public InLocoMediaException handleError(String url, Throwable error) {
        return this.handleError(url, null, error);
    }

    public InLocoMediaException handleError(String url, UrlResponse response) {
        return this.handleError(url, response, null);
    }

    public InLocoMediaException handleError(String url, UrlResponse response, Throwable error) {
        if (response != null) {
            if (response.isUnauthorized()) {
                return new UnauthorizedException("Unauthorized: " + response.getStatusCode());
            }
            if (this.mErrorHandlerManager != null) {
                try {
                    InLocoMediaException inLocoMediaException;
                    JSONObject jSONObject = this.getErrors(response);
                    if (jSONObject != null && (inLocoMediaException = this.mErrorHandlerManager.responseHandler(jSONObject)) != null) {
                        return inLocoMediaException;
                    }
                }
                catch (IOException | JSONException throwable) {
                    return new NetworkException((Exception)throwable, url);
                }
            }
            return new NetworkException(response.getStatusMessage(), response.getStatusCode(), url);
        }
        if (error != null) {
            if (error instanceof ConnectTimeoutException || error instanceof SocketTimeoutException) {
                return new TimeoutException(InLocoMediaException.getFormattedMessage(error), url, error);
            }
            if (error instanceof NetworkUnavailableException) {
                return (InLocoMediaException)error;
            }
            if (error instanceof IOException) {
                return new NetworkException(InLocoMediaException.getFormattedMessage(error) + " at url " + url, error);
            }
            return new InLocoMediaUnhandledException(InLocoMediaException.getFormattedMessage(error), error);
        }
        return new NetworkException("An unexpected flow occurred. No HttpResponse nor error was received");
    }

    protected JSONObject getErrors(UrlResponse response) throws IOException, JSONException {
        if (response.getData() == null || response.getData().length == 0) {
            return null;
        }
        String string = response.getContentType();
        if (string == null || !string.contains("application/json")) {
            return null;
        }
        String string2 = new String(response.getData(), "UTF-8");
        return new JSONObject(string2);
    }

    protected void validateContentType(UrlResponse response) {
        String string;
        String string2 = this.getParams().getHeaders().get("Accept");
        if (string2 != null && !HttpUtils.isAcceptableContentType(string2, string = response.getContentType())) {
            NetworkException networkException = new NetworkException("Incompatible data received. Expected '" + string2 + "' but received '" + string + "'", response.getRequestedUrl());
            response.setErrorReceived(networkException);
        }
    }

    protected void print() throws UnsupportedEncodingException {
        Log.d((String)a, (String)("Request " + this.mParams.getMethod() + " at " + this.mParams.getUrl()));
        Log.d((String)a, (String)("Request Headers: " + this.mParams.getHeaders()));
        if (this.mParams.getBody() != null) {
            Log.d((String)a, (String)("Request Body: Size: " + this.mParams.getBody().length + (this.mParams.isBodyReadable() ? "bytes, Content:  " + this.mParams.getBodyAsString() : "")));
        }
    }

    public abstract UrlResponse run();
}

