/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.amazon;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.communication.Communication;
import com.inlocomedia.android.core.communication.amazon.AWS4SignerForAuthorizationHeader;
import com.inlocomedia.android.core.communication.builders.HttpRequestBuilder;
import com.inlocomedia.android.core.communication.exception.KinesisPutRecordsException;
import com.inlocomedia.android.core.communication.requests.params.HttpRequestParams;
import com.inlocomedia.android.core.communication.util.BinaryUtils;
import com.inlocomedia.android.core.communication.util.RestfulMethod;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.Logger;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;

public class KinesisPutRecords {
    protected static final String CONTENT_TYPE = "application/x-amz-json-1.1";
    protected static final String AMZ_TARGET = "Kinesis_20131202.PutRecords";
    private static final String a = Logger.makeTag(KinesisPutRecords.class);
    public static final int REQUEST_LIMIT = 500;

    public static void put(Context context, String streamName, String partitionKey, List<String> records, String regionName, String awsAccessKey, String awsSecretKey) throws InLocoMediaException {
        if (records.size() > 500) {
            throw new KinesisPutRecordsException("Kinesis 'PutRecords' method only accepts 500 records, but " + records.size() + " records were given.");
        }
        if (records.size() == 0) {
            throw new KinesisPutRecordsException("Kinesis 'PutRecords' required at least one record, but no records were given.");
        }
        Communication.executeSync(KinesisPutRecords.a(context, streamName, partitionKey, records, regionName, awsAccessKey, awsSecretKey));
    }

    private static HttpRequestBuilder<Void> a(final Context context, final String string, final String string2, final List<String> list, final String string3, final String string4, final String string5) {
        return new HttpRequestBuilder<Void>(){

            @Override
            public HttpRequestParams build() throws Throwable {
                URL uRL = KinesisPutRecords.getEndpointUrl(string3);
                String string6 = KinesisPutRecords.getJsonBody(string, string2, list);
                HashMap<String, String> hashMap = KinesisPutRecords.getSignedHeaders(uRL, string6, string3, string4, string5);
                HttpRequestParams httpRequestParams = new HttpRequestParams(context, RestfulMethod.post(uRL.toString()));
                httpRequestParams.setHeaders(hashMap);
                httpRequestParams.setBody(string6);
                return httpRequestParams;
            }

            public Void a(byte[] byArray) throws Throwable {
                return null;
            }

            @Override
            public /* synthetic */ Object convert(byte[] byArray) throws Throwable {
                return this.a(byArray);
            }
        };
    }

    protected static URL getEndpointUrl(String regionName) {
        URL uRL;
        try {
            uRL = new URL("https://kinesis." + regionName + ".amazonaws.com/");
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Unable to parse service endpoint: " + malformedURLException.getMessage());
        }
        return uRL;
    }

    protected static String getJsonBody(String streamName, String partitionKey, List<String> records) throws UnsupportedEncodingException {
        String string;
        try {
            string = KinesisPutRecords.getJsonRecords(records, partitionKey);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Environment.isCommunicationDebug()) {
                Log.w((String)a, (String)"UTF-8 encoding is not supported.", (Throwable)unsupportedEncodingException);
            }
            throw unsupportedEncodingException;
        }
        return String.format("{\"StreamName\":\"%s\",\"Records\":[%s]}", streamName, string);
    }

    protected static HashMap<String, String> getSignedHeaders(URL endpointUrl, String body, String regionName, String awsAccessKey, String awsSecretKey) {
        byte[] byArray = AWS4SignerForAuthorizationHeader.hash(body);
        String string = BinaryUtils.toHex(byArray);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("content-type", CONTENT_TYPE);
        hashMap.put("x-amz-target", AMZ_TARGET);
        AWS4SignerForAuthorizationHeader aWS4SignerForAuthorizationHeader = new AWS4SignerForAuthorizationHeader(endpointUrl, "POST", "kinesis", regionName);
        String string2 = aWS4SignerForAuthorizationHeader.computeSignature(hashMap, null, string, awsAccessKey, awsSecretKey);
        hashMap.put("Authorization", string2);
        return hashMap;
    }

    protected static String getJsonRecords(List<String> records, String partitionKey) throws UnsupportedEncodingException {
        int n = records.size();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            String string = records.get(i);
            string = Base64.encodeToString((byte[])string.getBytes("UTF-8"), (int)2);
            string = String.format("{\"PartitionKey\":\"%s\",\"Data\":\"%s\"}", partitionKey, string);
            stringBuilder.append(string);
            if (i == n - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }
}

