/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.amazon;

import android.content.Context;
import android.util.Log;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.communication.amazon.AmazonCredentials;
import com.inlocomedia.android.core.communication.util.NetworkAccessTools;
import com.inlocomedia.android.core.exception.InvalidMappingException;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

public class AmazonS3Upload {
    private final Random a = new Random();
    private AmazonCredentials b;

    public AmazonS3Upload() {
        this.b = new AmazonCredentials();
    }

    public AmazonS3Upload(AmazonCredentials amazonCredentials) {
        this.b = amazonCredentials;
    }

    public void setCredentials(JSONObject json) throws InvalidMappingException, JSONException {
        this.b.parseFromJSON(json);
    }

    public void setCredentials(AmazonCredentials credentials) {
        this.b = credentials;
    }

    public boolean upload(Context context, File file) {
        return this.upload(context, file, this.a(10));
    }

    public boolean upload(Context context, File file, String folder) {
        boolean bl;
        block6: {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (Environment.isCommunicationDebug()) {
                    Log.e((String)"AmazonS3Upload", (String)"file not found", (Throwable)fileNotFoundException);
                }
                return false;
            }
            String string = file.getName();
            string = folder + "/" + string;
            bl = this.upload(context, fileInputStream, file.length(), string);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                if (!Environment.isCommunicationDebug()) break block6;
                if (bl) {
                    Log.e((String)"AmazonS3Upload", (String)"File sent, but could not close file stream", (Throwable)iOException);
                }
                Log.e((String)"AmazonS3Upload", (String)"Error while closing file", (Throwable)iOException);
            }
        }
        return bl;
    }

    private String a(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append((char)(97 + this.a.nextInt(26)));
        }
        return stringBuilder.toString();
    }

    public boolean upload(Context context, InputStream inputStream, long size, String key) {
        if (NetworkAccessTools.isNetworkAvailable(context)) {
            return this.upload(inputStream, size, key);
        }
        return false;
    }

    public boolean upload(InputStream inputStream, long size, String key) {
        boolean bl = true;
        if (!this.b.isValid()) {
            return false;
        }
        if (!this.b.getKey().equals("")) {
            key = this.b.getKey() + "/" + key;
        }
        String string = this.b.getUrl();
        HttpURLConnection httpURLConnection = null;
        DataOutputStream dataOutputStream = null;
        String string2 = "\r\n";
        String string3 = "--";
        String string4 = "*****" + this.a(8);
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setConnectTimeout(60000);
            httpURLConnection.setReadTimeout(60000);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string4);
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(httpURLConnection.getOutputStream()));
            this.a(dataOutputStream, string2, string3, string4, "key", key);
            this.a(dataOutputStream, string2, string3, string4, "acl", "private");
            this.a(dataOutputStream, string2, string3, string4, "AWSAccessKeyId", this.b.getAwsAccessKeyId());
            this.a(dataOutputStream, string2, string3, string4, "policy", this.b.getPolicy());
            this.a(dataOutputStream, string2, string3, string4, "signature", this.b.getSignature());
            dataOutputStream.writeBytes(string3 + string4 + string2);
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"file\"" + string2);
            dataOutputStream.writeBytes("Content-Type: application/octet-stream" + string2);
            dataOutputStream.writeBytes("Content-Transfer-Encoding: binary" + string2);
            if (size >= 0L) {
                dataOutputStream.writeBytes("Content-Length: " + size + string2);
            }
            dataOutputStream.writeBytes(string2);
            int n = 65536;
            if (size >= 0L) {
                n = (int)Math.min(size, 65536L);
            }
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray, 0, n);
            while (n2 > 0) {
                dataOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray, 0, n);
            }
            dataOutputStream.writeBytes(string2);
            dataOutputStream.writeBytes(string3 + string4 + string3 + string2);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            if (Environment.isCommunicationDebug()) {
                Log.e((String)"AmazonS3Upload", (String)"UploadService Runnable:Client Request error", (Throwable)exception);
            }
            bl = false;
        }
        try {
            if (httpURLConnection == null) {
                if (Environment.isCommunicationDebug()) {
                    Log.e((String)"AmazonS3Upload", (String)"Url connection is null. Request failed for S3 Upload");
                }
                bl = false;
            } else if (httpURLConnection.getResponseCode() < 200 || httpURLConnection.getResponseCode() >= 300) {
                if (Environment.isCommunicationDebug()) {
                    Log.e((String)"AmazonS3Upload", (String)("Response error Code:" + httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage()));
                }
                bl = false;
            }
        }
        catch (IOException iOException) {
            if (Environment.isCommunicationDebug()) {
                Log.e((String)"AmazonS3Upload", (String)"Connection error", (Throwable)iOException);
            }
            bl = false;
        }
        return bl;
    }

    private void a(DataOutputStream dataOutputStream, String string, String string2, String string3, String string4, String string5) throws IOException {
        dataOutputStream.writeBytes(string2 + string3 + string);
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"" + string4 + "\"" + string);
        dataOutputStream.writeBytes("Content-Type: text/plain; charset=US-ASCII" + string);
        dataOutputStream.writeBytes("Content-Transfer-Encoding: 8bit" + string);
        dataOutputStream.writeBytes(string);
        dataOutputStream.writeBytes(string5 + string);
    }
}

