/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication.amazon;

import android.util.Log;
import com.inlocomedia.android.core.Environment;
import com.inlocomedia.android.core.communication.util.BinaryUtils;
import com.inlocomedia.android.core.log.Logger;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AWS4SignerForAuthorizationHeader {
    public static final String SCHEME = "AWS4";
    public static final String ALGORITHM = "HMAC-SHA256";
    public static final String TERMINATOR = "aws4_request";
    public static final String ISO8601BasicFormat = "yyyyMMdd'T'HHmmss'Z'";
    public static final String DateStringFormat = "yyyyMMdd";
    private static final String a = Logger.makeTag(AWS4SignerForAuthorizationHeader.class);
    private URL b;
    private String c;
    private String d;
    private String e;
    private final SimpleDateFormat f;
    private final SimpleDateFormat g;

    public AWS4SignerForAuthorizationHeader(URL endpointUrl, String httpMethod, String serviceName, String regionName) {
        this.b = endpointUrl;
        this.c = httpMethod;
        this.d = serviceName;
        this.e = regionName;
        this.f = new SimpleDateFormat(ISO8601BasicFormat, Locale.US);
        this.f.setTimeZone(new SimpleTimeZone(0, "UTC"));
        this.g = new SimpleDateFormat(DateStringFormat, Locale.US);
        this.g.setTimeZone(new SimpleTimeZone(0, "UTC"));
    }

    public String computeSignature(Map<String, String> headers, Map<String, String> queryParameters, String bodyHash, String awsAccessKey, String awsSecretKey) {
        Date date = new Date();
        String string = this.f.format(date);
        headers.put("x-amz-date", string);
        StringBuilder stringBuilder = new StringBuilder(this.b.getHost());
        int n = this.b.getPort();
        if (n > -1) {
            stringBuilder.append(":").append(Integer.toString(n));
        }
        headers.put("Host", stringBuilder.toString());
        String string2 = AWS4SignerForAuthorizationHeader.a(headers);
        String string3 = AWS4SignerForAuthorizationHeader.b(headers);
        String string4 = AWS4SignerForAuthorizationHeader.getCanonicalizedQueryString(queryParameters);
        String string5 = AWS4SignerForAuthorizationHeader.a(this.b, this.c, string4, string2, string3, bodyHash);
        if (Environment.isCommunicationDebug()) {
            Log.d((String)a, (String)"--------- Canonical request --------");
            Log.d((String)a, (String)string5);
            Log.d((String)a, (String)"------------------------------------");
        }
        String string6 = this.g.format(date);
        String string7 = string6 + "/" + this.e + "/" + this.d + "/" + TERMINATOR;
        String string8 = AWS4SignerForAuthorizationHeader.a(SCHEME, ALGORITHM, string, string7, string5);
        if (Environment.isCommunicationDebug()) {
            Log.d((String)a, (String)"--------- String to sign -----------");
            Log.d((String)a, (String)string8);
            Log.d((String)a, (String)"------------------------------------");
        }
        byte[] byArray = (SCHEME + awsSecretKey).getBytes();
        byte[] byArray2 = AWS4SignerForAuthorizationHeader.a(string6, byArray, "HmacSHA256");
        byte[] byArray3 = AWS4SignerForAuthorizationHeader.a(this.e, byArray2, "HmacSHA256");
        byte[] byArray4 = AWS4SignerForAuthorizationHeader.a(this.d, byArray3, "HmacSHA256");
        byte[] byArray5 = AWS4SignerForAuthorizationHeader.a(TERMINATOR, byArray4, "HmacSHA256");
        byte[] byArray6 = AWS4SignerForAuthorizationHeader.a(string8, byArray5, "HmacSHA256");
        String string9 = "Credential=" + awsAccessKey + "/" + string7;
        String string10 = "SignedHeaders=" + string2;
        String string11 = "Signature=" + BinaryUtils.toHex(byArray6);
        String string12 = "AWS4-HMAC-SHA256 " + string9 + ", " + string10 + ", " + string11;
        return string12;
    }

    private static String a(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(map.keySet());
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(string.toLowerCase());
        }
        return stringBuilder.toString();
    }

    private static String b(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(map.keySet());
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            stringBuilder.append(string.toLowerCase().replaceAll("\\s+", " ")).append(":").append(map.get(string).replaceAll("\\s+", " "));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private static String a(URL uRL, String string, String string2, String string3, String string4, String string5) {
        String string6 = string + "\n" + AWS4SignerForAuthorizationHeader.a(uRL) + "\n" + string2 + "\n" + string4 + "\n" + string3 + "\n" + string5;
        return string6;
    }

    private static String a(URL uRL) {
        if (uRL == null) {
            return "/";
        }
        String string = uRL.getPath();
        if (string == null || string.isEmpty()) {
            return "/";
        }
        String string2 = AWS4SignerForAuthorizationHeader.a(string, true);
        if (string2.startsWith("/")) {
            return string2;
        }
        return "/".concat(string2);
    }

    public static String getCanonicalizedQueryString(Map<String, String> parameters) {
        Object object;
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> object22 : parameters.entrySet()) {
            object = object22.getKey();
            String string = object22.getValue();
            treeMap.put(AWS4SignerForAuthorizationHeader.a((String)object, false), AWS4SignerForAuthorizationHeader.a(string, false));
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuilder.append((String)object.getKey());
            stringBuilder.append("=");
            stringBuilder.append((String)object.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    private static String a(String string, String string2, String string3, String string4, String string5) {
        String string6 = string + "-" + string2 + "\n" + string3 + "\n" + string4 + "\n" + BinaryUtils.toHex(AWS4SignerForAuthorizationHeader.hash(string5));
        return string6;
    }

    public static byte[] hash(String text) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(text.getBytes("UTF-8"));
            return messageDigest.digest();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to compute hash while signing request: " + exception.getMessage(), exception);
        }
    }

    private static byte[] a(String string, byte[] byArray, String string2) {
        try {
            byte[] byArray2 = string.getBytes("UTF-8");
            Mac mac = Mac.getInstance(string2);
            mac.init(new SecretKeySpec(byArray, string2));
            return mac.doFinal(byArray2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to calculate a request signature: " + exception.getMessage(), exception);
        }
    }

    private static String a(String string, boolean bl) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 encoding is not supported.", unsupportedEncodingException);
        }
        if (bl) {
            string2 = string2.replace("%2F", "/");
        }
        return string2;
    }
}

