/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.communication;

import android.content.Context;
import com.inlocomedia.android.core.communication.AuthRequestBuilder;
import com.inlocomedia.android.core.communication.AuthenticationToken;
import com.inlocomedia.android.core.communication.CommunicationRequest;
import com.inlocomedia.android.core.communication.builders.BaseAuthenticationRequestBuilder;
import com.inlocomedia.android.core.communication.builders.HttpRequestBuilder;
import com.inlocomedia.android.core.communication.exception.TimeoutException;
import com.inlocomedia.android.core.communication.interfaces.RequestListener;
import com.inlocomedia.android.core.communication.requests.params.HttpRequestParams;
import com.inlocomedia.android.core.communication.responses.UrlResponse;
import com.inlocomedia.android.core.communication.util.HttpClientFactory;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.exception.InLocoMediaUnhandledException;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public final class Communication {
    private Communication() {
    }

    public static <T> T executeSync(HttpRequestBuilder<T> builder) throws InLocoMediaException {
        return Communication.executeSync(builder, 0L);
    }

    public static <T> T executeSync(HttpRequestBuilder<T> builder, long timeout) throws InLocoMediaException {
        final CommunicationRequest<T> communicationRequest = new CommunicationRequest<T>(builder);
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return Communication.b(communicationRequest);
            }
        };
        try {
            Object object;
            if (timeout == 0L) {
                object = callable.call();
            } else {
                Future future = ThreadPool.submit(callable);
                object = future.get(timeout, TimeUnit.MILLISECONDS);
            }
            communicationRequest.finish();
            return (T)object;
        }
        catch (Throwable throwable) {
            communicationRequest.finish();
            throw Communication.b(throwable);
        }
    }

    public static <T> CommunicationRequest<T> executeAsync(HttpRequestBuilder<T> builder, RequestListener<T> listener) {
        return Communication.executeAsync(builder, listener, 0L, false);
    }

    public static <T> CommunicationRequest<T> executeAsync(HttpRequestBuilder<T> builder, RequestListener<T> listener, long timeout, TimeUnit timeUnit) {
        return Communication.executeAsync(builder, listener, timeUnit != TimeUnit.MILLISECONDS ? timeUnit.toMillis(timeout) : timeout);
    }

    public static <T> CommunicationRequest<T> executeAsync(HttpRequestBuilder<T> builder, RequestListener<T> listener, long timeout) {
        return Communication.executeAsync(builder, listener, timeout, false);
    }

    public static <T> CommunicationRequest executeWithThreadLimit(HttpRequestBuilder<T> builder, RequestListener<T> listener) {
        return Communication.executeAsync(builder, listener, 0L, true);
    }

    public static <T> CommunicationRequest<T> executeAsync(HttpRequestBuilder<T> builder, final RequestListener<T> listener, final long timeout, boolean threadLimit) {
        CommunicationRequest communicationRequest;
        block3: {
            communicationRequest = new CommunicationRequest(builder);
            try {
                Callable callable = new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        Object object = null;
                        InLocoMediaException inLocoMediaException = null;
                        try {
                            object = Communication.b(communicationRequest);
                        }
                        catch (InLocoMediaException inLocoMediaException2) {
                            inLocoMediaException = Communication.b(inLocoMediaException2);
                        }
                        if (timeout == 0L && communicationRequest.isActiveAndFinish() && listener != null) {
                            if (inLocoMediaException == null) {
                                listener.onRequestFinished(object);
                            } else {
                                listener.onRequestFailed(inLocoMediaException);
                            }
                        }
                        if (inLocoMediaException != null) {
                            throw inLocoMediaException;
                        }
                        return object;
                    }
                };
                final Future future = ThreadPool.submit(callable, threadLimit);
                communicationRequest.setFuture(future);
                if (timeout > 0L) {
                    ThreadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    Object v = future.get(timeout, TimeUnit.MILLISECONDS);
                                    if (communicationRequest.isActiveAndFinish() && listener != null) {
                                        listener.onRequestFinished(v);
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (!communicationRequest.isActiveAndFinish() || listener == null) break block3;
                                    InLocoMediaException inLocoMediaException = Communication.b(throwable);
                                    listener.onRequestFailed(inLocoMediaException);
                                }
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                if (!communicationRequest.isActiveAndFinish() || listener == null) break block3;
                InLocoMediaException inLocoMediaException = Communication.b(throwable);
                listener.onRequestFailed(inLocoMediaException);
            }
        }
        return communicationRequest;
    }

    private static <T> T b(CommunicationRequest<T> communicationRequest) throws InLocoMediaException {
        try {
            Object object;
            communicationRequest.start();
            AuthRequestBuilder<?> authRequestBuilder = communicationRequest.getBuilder().getAuthenticationBuilder();
            if (communicationRequest.getBuilder().isAuthEnabled() && (object = communicationRequest.getBuilder().getAuthenticationBuilder().getAuthenticationToken()) != null && Validator.isNullOrEmpty(((AuthenticationToken)object).getToken())) {
                Communication.onAuthenticationChallenge(authRequestBuilder, communicationRequest);
                return Communication.b(communicationRequest);
            }
            object = communicationRequest.getBuilder().build();
            if (authRequestBuilder != null) {
                authRequestBuilder.addTokenToRequest((HttpRequestParams)object);
            }
            communicationRequest.setHttpRequest(HttpClientFactory.newHttpClientRequest((HttpRequestParams)object, communicationRequest.getBuilder().getErrorHandler()));
            UrlResponse urlResponse = communicationRequest.getHttpRequest().run();
            T t = null;
            if (urlResponse.isUnauthorized() && authRequestBuilder != null && authRequestBuilder.isAuthEnabled()) {
                Communication.onAuthenticationChallenge(authRequestBuilder, communicationRequest);
                return Communication.b(communicationRequest);
            }
            if (urlResponse.isSuccessful()) {
                try {
                    t = communicationRequest.getBuilder().convert(urlResponse.getData());
                }
                catch (Throwable throwable) {
                    communicationRequest.getHttpRequest().removeCached();
                    urlResponse.setErrorReceived(new InLocoMediaUnhandledException(throwable));
                }
            }
            if (urlResponse.isSuccessful()) {
                return t;
            }
            throw urlResponse.getErrorReceived();
        }
        catch (InLocoMediaException inLocoMediaException) {
            throw inLocoMediaException;
        }
        catch (Throwable throwable) {
            throw new InLocoMediaUnhandledException(throwable);
        }
    }

    public static AuthRequestBuilder<JSONObject> getBaseAuthenticationBuilder(Context context, AuthenticationToken token) {
        return new BaseAuthenticationRequestBuilder(context, token);
    }

    public static <T> void onAuthenticationChallenge(AuthRequestBuilder<T> authBuilder, CommunicationRequest<?> request) throws InLocoMediaException {
        authBuilder.setErrorHandlerManager(request.getBuilder().getErrorHandler());
        CommunicationRequest<T> communicationRequest = new CommunicationRequest<T>(authBuilder);
        T t = Communication.b(communicationRequest);
        request.getBuilder().disableAuth();
        authBuilder.onAuthCompleted(t);
    }

    private static InLocoMediaException b(Throwable throwable) {
        if (throwable instanceof RejectedExecutionException) {
            return new InLocoMediaException("Communication ThreadPool rejected request", throwable);
        }
        if (throwable instanceof java.util.concurrent.TimeoutException | throwable instanceof InterruptedException) {
            return new TimeoutException("Request reached timeout");
        }
        if (throwable instanceof InLocoMediaException) {
            return (InLocoMediaException)throwable;
        }
        if (throwable instanceof ExecutionException) {
            Throwable throwable2;
            Throwable throwable3 = throwable2 = throwable.getCause() != null ? throwable.getCause() : throwable;
            if (throwable2 instanceof InLocoMediaException) {
                return (InLocoMediaException)throwable2;
            }
            return new InLocoMediaUnhandledException(throwable2);
        }
        return new InLocoMediaUnhandledException(throwable);
    }
}

