/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.core.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.inlocomedia.android.core.exception.InvalidMappingException;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.util.Validator;
import java.text.Normalizer;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public final class Utils {
    private static final String a = Logger.makeTag(Utils.class);
    private static final Pattern b = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");

    private Utils() {
    }

    public static String getMetadata(Context context, String key) {
        Validator.notNull(context, "context");
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                return applicationInfo.metaData.getString(key);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static boolean bitMaskContainsFlag(int bitMask, int flag) {
        return (bitMask & flag) != 0;
    }

    public static void putAll(JSONObject json, JSONObject ... jsonObjects) throws InvalidMappingException {
        for (JSONObject jSONObject : jsonObjects) {
            if (jSONObject == null) continue;
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    json.put(string, jSONObject.get(string));
                }
                catch (JSONException jSONException) {
                    throw new InvalidMappingException("Invalid json mapping");
                }
            }
        }
    }

    public static boolean equals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public static String stripAccents(String input) {
        if (input == null) {
            return null;
        }
        String string = Normalizer.normalize(input, Normalizer.Form.NFD);
        return b.matcher(string).replaceAll("");
    }

    @SuppressLint(value={"NewApi"})
    public static void applyOrCommit(SharedPreferences.Editor editor) {
        if (Validator.isAboveAndroid8()) {
            editor.apply();
        } else {
            editor.commit();
        }
    }
}

